/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.internal.partition;

import com.att.aft.dme2.hazelcast.nio.Address;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.DataSerializable;
import com.att.aft.dme2.hazelcast.util.UuidUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;

public class MigrationInfo
implements DataSerializable {
    private String uuid;
    private int partitionId;
    private Address source;
    private String sourceUuid;
    private Address destination;
    private String destinationUuid;
    private Address master;
    private int sourceCurrentReplicaIndex;
    private int sourceNewReplicaIndex;
    private int destinationCurrentReplicaIndex;
    private int destinationNewReplicaIndex;
    private final AtomicBoolean processing = new AtomicBoolean(false);
    private volatile MigrationStatus status;

    public MigrationInfo() {
    }

    public MigrationInfo(int partitionId, Address source, String sourceUuid, Address destination, String destinationUuid, int sourceCurrentReplicaIndex, int sourceNewReplicaIndex, int destinationCurrentReplicaIndex, int destinationNewReplicaIndex) {
        this.uuid = UuidUtil.newUnsecureUuidString();
        this.partitionId = partitionId;
        this.source = source;
        this.sourceUuid = sourceUuid;
        this.destination = destination;
        this.destinationUuid = destinationUuid;
        this.sourceCurrentReplicaIndex = sourceCurrentReplicaIndex;
        this.sourceNewReplicaIndex = sourceNewReplicaIndex;
        this.destinationCurrentReplicaIndex = destinationCurrentReplicaIndex;
        this.destinationNewReplicaIndex = destinationNewReplicaIndex;
        this.status = MigrationStatus.ACTIVE;
    }

    public Address getSource() {
        return this.source;
    }

    public String getSourceUuid() {
        return this.sourceUuid;
    }

    public Address getDestination() {
        return this.destination;
    }

    public String getDestinationUuid() {
        return this.destinationUuid;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public int getSourceCurrentReplicaIndex() {
        return this.sourceCurrentReplicaIndex;
    }

    public int getSourceNewReplicaIndex() {
        return this.sourceNewReplicaIndex;
    }

    public int getDestinationCurrentReplicaIndex() {
        return this.destinationCurrentReplicaIndex;
    }

    public int getDestinationNewReplicaIndex() {
        return this.destinationNewReplicaIndex;
    }

    public Address getMaster() {
        return this.master;
    }

    public MigrationInfo setMaster(Address master) {
        this.master = master;
        return this;
    }

    public boolean startProcessing() {
        return this.processing.compareAndSet(false, true);
    }

    public boolean isProcessing() {
        return this.processing.get();
    }

    public void doneProcessing() {
        this.processing.set(false);
    }

    public MigrationStatus getStatus() {
        return this.status;
    }

    public MigrationInfo setStatus(MigrationStatus status) {
        this.status = status;
        return this;
    }

    public boolean isValid() {
        return this.status != MigrationStatus.INVALID;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.uuid);
        out.writeInt(this.partitionId);
        out.writeByte(this.sourceCurrentReplicaIndex);
        out.writeByte(this.sourceNewReplicaIndex);
        out.writeByte(this.destinationCurrentReplicaIndex);
        out.writeByte(this.destinationNewReplicaIndex);
        MigrationStatus.writeTo(this.status, out);
        boolean hasSource = this.source != null;
        out.writeBoolean(hasSource);
        if (hasSource) {
            this.source.writeData(out);
            out.writeUTF(this.sourceUuid);
        }
        boolean hasDestination = this.destination != null;
        out.writeBoolean(hasDestination);
        if (hasDestination) {
            this.destination.writeData(out);
            out.writeUTF(this.destinationUuid);
        }
        this.master.writeData(out);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        boolean hasDestination;
        this.uuid = in.readUTF();
        this.partitionId = in.readInt();
        this.sourceCurrentReplicaIndex = in.readByte();
        this.sourceNewReplicaIndex = in.readByte();
        this.destinationCurrentReplicaIndex = in.readByte();
        this.destinationNewReplicaIndex = in.readByte();
        this.status = MigrationStatus.readFrom(in);
        boolean hasSource = in.readBoolean();
        if (hasSource) {
            this.source = new Address();
            this.source.readData(in);
            this.sourceUuid = in.readUTF();
        }
        if (hasDestination = in.readBoolean()) {
            this.destination = new Address();
            this.destination.readData(in);
            this.destinationUuid = in.readUTF();
        }
        this.master = new Address();
        this.master.readData(in);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MigrationInfo that = (MigrationInfo)o;
        return this.uuid.equals(that.uuid);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MigrationInfo{");
        sb.append("uuid=").append(this.uuid);
        sb.append(", partitionId=").append(this.partitionId);
        sb.append(", source=").append(this.source);
        sb.append(", sourceUuid=").append(this.sourceUuid);
        sb.append(", sourceCurrentReplicaIndex=").append(this.sourceCurrentReplicaIndex);
        sb.append(", sourceNewReplicaIndex=").append(this.sourceNewReplicaIndex);
        sb.append(", destination=").append(this.destination);
        sb.append(", destinationUuid=").append(this.destinationUuid);
        sb.append(", destinationCurrentReplicaIndex=").append(this.destinationCurrentReplicaIndex);
        sb.append(", destinationNewReplicaIndex=").append(this.destinationNewReplicaIndex);
        sb.append(", master=").append(this.master);
        sb.append(", processing=").append(this.processing);
        sb.append(", status=").append((Object)this.status);
        sb.append('}');
        return sb.toString();
    }

    public static enum MigrationStatus {
        ACTIVE(0),
        INVALID(1),
        SUCCESS(2),
        FAILED(3);

        private final int code;

        private MigrationStatus(int code) {
            this.code = code;
        }

        public static void writeTo(MigrationStatus type, DataOutput out) throws IOException {
            out.writeByte(type.code);
        }

        public static MigrationStatus readFrom(DataInput in) throws IOException {
            byte code = in.readByte();
            switch (code) {
                case 0: {
                    return ACTIVE;
                }
                case 1: {
                    return INVALID;
                }
                case 2: {
                    return SUCCESS;
                }
                case 3: {
                    return FAILED;
                }
            }
            throw new IllegalArgumentException("Code: " + code);
        }
    }
}

