/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.internal.partition;

import com.att.aft.dme2.hazelcast.internal.partition.InternalPartition;
import com.att.aft.dme2.hazelcast.internal.partition.MigrationInfo;
import com.att.aft.dme2.hazelcast.internal.partition.impl.PartitionDataSerializerHook;
import com.att.aft.dme2.hazelcast.nio.Address;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.att.aft.dme2.hazelcast.util.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class PartitionRuntimeState
implements IdentifiedDataSerializable {
    private Map<Address, Integer> addressToIndexes;
    private Address[] addresses;
    private int[][] minimizedPartitionTable;
    private int version;
    private Collection<MigrationInfo> completedMigrations;
    private MigrationInfo activeMigration;
    private Address endpoint;

    public PartitionRuntimeState() {
    }

    public PartitionRuntimeState(InternalPartition[] partitions, Collection<MigrationInfo> migrationInfos, int version) {
        this.version = version;
        this.completedMigrations = migrationInfos != null ? migrationInfos : Collections.emptyList();
        this.addressToIndexes = this.createAddressToIndexMap(partitions);
        this.minimizedPartitionTable = this.createMinimizedPartitionTable(partitions);
    }

    private int[][] createMinimizedPartitionTable(InternalPartition[] partitions) {
        int[][] partitionTable = new int[partitions.length][7];
        for (InternalPartition partition : partitions) {
            int[] indexes = partitionTable[partition.getPartitionId()];
            for (int replicaIndex = 0; replicaIndex < 7; ++replicaIndex) {
                int index;
                Address address = partition.getReplicaAddress(replicaIndex);
                indexes[replicaIndex] = address == null ? -1 : (index = this.addressToIndexes.get(address).intValue());
            }
        }
        return partitionTable;
    }

    private Map<Address, Integer> createAddressToIndexMap(InternalPartition[] partitions) {
        HashMap<Address, Integer> map = new HashMap<Address, Integer>();
        int addressIndex = 0;
        for (InternalPartition partition : partitions) {
            for (int i = 0; i < 7; ++i) {
                Address address = partition.getReplicaAddress(i);
                if (address == null || map.containsKey(address)) continue;
                map.put(address, addressIndex++);
            }
        }
        return map;
    }

    public Address[][] getPartitionTable() {
        if (this.addresses == null) {
            this.addresses = new Address[this.addressToIndexes.size()];
            for (Map.Entry<Address, Integer> entry : this.addressToIndexes.entrySet()) {
                this.addresses[entry.getValue().intValue()] = entry.getKey();
            }
        }
        int length = this.minimizedPartitionTable.length;
        Address[][] result = new Address[length][7];
        for (int partitionId = 0; partitionId < length; ++partitionId) {
            Address[] replicas = result[partitionId];
            int[] addressIndexes = this.minimizedPartitionTable[partitionId];
            for (int replicaIndex = 0; replicaIndex < addressIndexes.length; ++replicaIndex) {
                int index = addressIndexes[replicaIndex];
                if (index == -1) continue;
                Address address = this.addresses[index];
                assert (address != null);
                replicas[replicaIndex] = address;
            }
        }
        return result;
    }

    public Address getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Address endpoint) {
        this.endpoint = endpoint;
    }

    public Collection<MigrationInfo> getCompletedMigrations() {
        return this.completedMigrations != null ? this.completedMigrations : Collections.emptyList();
    }

    public MigrationInfo getActiveMigration() {
        return this.activeMigration;
    }

    public void setActiveMigration(MigrationInfo activeMigration) {
        this.activeMigration = activeMigration;
    }

    public void setCompletedMigrations(Collection<MigrationInfo> completedMigrations) {
        this.completedMigrations = completedMigrations;
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int k;
        this.version = in.readInt();
        int memberCount = in.readInt();
        this.addresses = new Address[memberCount];
        for (int i = 0; i < memberCount; ++i) {
            Address address = new Address();
            address.readData(in);
            int index = in.readInt();
            assert (this.addresses[index] == null) : "Duplicate address! Address: " + address + ", index: " + index + ", addresses: " + Arrays.toString(this.addresses);
            this.addresses[index] = address;
        }
        int partitionCount = in.readInt();
        this.minimizedPartitionTable = new int[partitionCount][7];
        for (int i = 0; i < partitionCount; ++i) {
            int[] indexes = this.minimizedPartitionTable[i];
            for (int ix = 0; ix < 7; ++ix) {
                indexes[ix] = in.readInt();
            }
        }
        if (in.readBoolean()) {
            this.activeMigration = new MigrationInfo();
            this.activeMigration.readData(in);
        }
        if ((k = in.readInt()) > 0) {
            this.completedMigrations = new ArrayList<MigrationInfo>(k);
            for (int i = 0; i < k; ++i) {
                MigrationInfo migrationInfo = new MigrationInfo();
                migrationInfo.readData(in);
                this.completedMigrations.add(migrationInfo);
            }
        }
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.version);
        if (this.addressToIndexes == null) {
            out.writeInt(this.addresses.length);
            for (int index = 0; index < this.addresses.length; ++index) {
                Address address = this.addresses[index];
                address.writeData(out);
                out.writeInt(index);
            }
        } else {
            int memberCount = this.addressToIndexes.size();
            out.writeInt(memberCount);
            for (Map.Entry<Address, Integer> entry : this.addressToIndexes.entrySet()) {
                Address address = entry.getKey();
                address.writeData(out);
                int index = entry.getValue();
                out.writeInt(index);
            }
        }
        out.writeInt(this.minimizedPartitionTable.length);
        for (int[] indexes : this.minimizedPartitionTable) {
            for (int ix = 0; ix < 7; ++ix) {
                out.writeInt(indexes[ix]);
            }
        }
        if (this.activeMigration != null) {
            out.writeBoolean(true);
            this.activeMigration.writeData(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.completedMigrations != null) {
            int k = this.completedMigrations.size();
            out.writeInt(k);
            for (MigrationInfo migrationInfo : this.completedMigrations) {
                migrationInfo.writeData(out);
            }
        } else {
            out.writeInt(0);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PartitionRuntimeState [" + this.version + "]{" + StringUtil.LINE_SEPARATOR);
        if (this.addressToIndexes == null) {
            for (Address address : this.addresses) {
                sb.append(address).append(StringUtil.LINE_SEPARATOR);
            }
        } else {
            for (Address address : this.addressToIndexes.keySet()) {
                sb.append(address).append(StringUtil.LINE_SEPARATOR);
            }
        }
        sb.append(", completedMigrations=").append(this.completedMigrations);
        sb.append('}');
        return sb.toString();
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    public int getFactoryId() {
        return PartitionDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 1;
    }
}

