/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.internal.partition.impl;

import com.att.aft.dme2.hazelcast.instance.Node;
import com.att.aft.dme2.hazelcast.instance.NodeState;
import com.att.aft.dme2.hazelcast.internal.partition.InternalPartitionService;
import com.att.aft.dme2.hazelcast.internal.partition.impl.InternalPartitionServiceImpl;
import com.att.aft.dme2.hazelcast.internal.partition.impl.MigrationManager;
import com.att.aft.dme2.hazelcast.logging.ILogger;

class PublishPartitionRuntimeStateTask
implements Runnable {
    private final Node node;
    private final InternalPartitionServiceImpl partitionService;
    private final ILogger logger;

    PublishPartitionRuntimeStateTask(Node node, InternalPartitionServiceImpl partitionService) {
        this.node = node;
        this.partitionService = partitionService;
        this.logger = node.getLogger(InternalPartitionService.class);
    }

    @Override
    public void run() {
        if (this.node.isMaster() && this.node.getState() == NodeState.ACTIVE) {
            boolean migrationAllowed;
            MigrationManager migrationManager = this.partitionService.getMigrationManager();
            boolean bl = migrationAllowed = migrationManager.isMigrationAllowed() && !this.partitionService.isFetchMostRecentPartitionTableTaskRequired();
            if (!migrationAllowed) {
                this.logger.fine("Not publishing partition runtime state since migration is not allowed.");
                return;
            }
            if (migrationManager.hasOnGoingMigration()) {
                this.logger.info("Remaining migration tasks in queue => " + this.partitionService.getMigrationQueueSize());
            }
            this.partitionService.publishPartitionRuntimeState();
        }
    }
}

