/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.internal.partition.operation;

import com.att.aft.dme2.hazelcast.core.MigrationEvent;
import com.att.aft.dme2.hazelcast.internal.partition.operation.AbstractPromotionOperation;
import com.att.aft.dme2.hazelcast.logging.ILogger;
import com.att.aft.dme2.hazelcast.spi.MigrationAwareService;
import com.att.aft.dme2.hazelcast.spi.PartitionMigrationEvent;

final class BeforePromotionOperation
extends AbstractPromotionOperation {
    BeforePromotionOperation(int currentReplicaIndex) {
        super(currentReplicaIndex);
    }

    @Override
    public void beforeRun() throws Exception {
        this.sendMigrationEvent(MigrationEvent.MigrationStatus.STARTED);
    }

    @Override
    public void run() throws Exception {
        ILogger logger = this.getLogger();
        if (logger.isFinestEnabled()) {
            logger.finest("Running before promotion for " + this.getPartitionMigrationEvent());
        }
        PartitionMigrationEvent event = this.getPartitionMigrationEvent();
        for (MigrationAwareService service : this.getMigrationAwareServices()) {
            try {
                service.beforeMigration(event);
            }
            catch (Throwable e) {
                logger.warning("While promoting partitionId=" + this.getPartitionId(), e);
            }
        }
    }
}

