/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.internal.partition.operation;

import com.att.aft.dme2.hazelcast.internal.partition.ReplicaErrorLogger;
import com.att.aft.dme2.hazelcast.internal.partition.impl.InternalPartitionServiceImpl;
import com.att.aft.dme2.hazelcast.logging.ILogger;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.spi.Operation;
import com.att.aft.dme2.hazelcast.spi.PartitionAwareOperation;
import com.att.aft.dme2.hazelcast.spi.impl.AllowedDuringPassiveState;
import java.io.IOException;

public final class CheckReplicaVersion
extends Operation
implements PartitionAwareOperation,
AllowedDuringPassiveState {
    private long version;
    private boolean returnResponse;
    private boolean response;

    public CheckReplicaVersion() {
    }

    public CheckReplicaVersion(long version, boolean returnResponse) {
        this.version = version;
        this.returnResponse = returnResponse;
    }

    @Override
    public void beforeRun() throws Exception {
    }

    @Override
    public void run() throws Exception {
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        int partitionId = this.getPartitionId();
        int replicaIndex = this.getReplicaIndex();
        long[] currentVersions = partitionService.getPartitionReplicaVersions(partitionId);
        long currentVersion = currentVersions[replicaIndex - 1];
        if (currentVersion == this.version) {
            this.response = true;
        } else {
            this.logBackupVersionMismatch(currentVersion);
            partitionService.getReplicaManager().triggerPartitionReplicaSync(partitionId, replicaIndex, 0L);
            this.response = false;
        }
    }

    private void logBackupVersionMismatch(long currentVersion) {
        ILogger logger = this.getLogger();
        if (logger.isFinestEnabled()) {
            logger.finest("partitionId=" + this.getPartitionId() + ", replicaIndex=" + this.getReplicaIndex() + " version is not matching to version of the owner! " + " expected-version=" + this.version + ", current-version=" + currentVersion);
        }
    }

    @Override
    public void afterRun() throws Exception {
    }

    @Override
    public boolean returnsResponse() {
        return this.returnResponse;
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    @Override
    public boolean validatesTarget() {
        return false;
    }

    @Override
    public String getServiceName() {
        return "hz:core:partitionService";
    }

    @Override
    public void logError(Throwable e) {
        ReplicaErrorLogger.log(e, this.getLogger());
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeLong(this.version);
        out.writeBoolean(this.returnResponse);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.version = in.readLong();
        this.returnResponse = in.readBoolean();
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(", version=").append(this.version);
    }
}

