/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.internal.partition.operation;

import com.att.aft.dme2.hazelcast.core.MemberLeftException;
import com.att.aft.dme2.hazelcast.internal.partition.MigrationCycleOperation;
import com.att.aft.dme2.hazelcast.internal.partition.PartitionRuntimeState;
import com.att.aft.dme2.hazelcast.internal.partition.impl.InternalPartitionServiceImpl;
import com.att.aft.dme2.hazelcast.nio.Address;
import com.att.aft.dme2.hazelcast.spi.AbstractOperation;
import com.att.aft.dme2.hazelcast.spi.ExceptionAction;
import com.att.aft.dme2.hazelcast.spi.exception.RetryableHazelcastException;
import com.att.aft.dme2.hazelcast.spi.exception.TargetNotMemberException;

public final class FetchPartitionStateOperation
extends AbstractOperation
implements MigrationCycleOperation {
    private PartitionRuntimeState partitionState;

    @Override
    public void run() {
        Address master;
        Address caller = this.getCallerAddress();
        if (!caller.equals(master = this.getNodeEngine().getMasterAddress())) {
            String msg = caller + " requested our partition table but it's not our known master. " + "Master: " + master;
            this.getLogger().warning(msg);
            throw new RetryableHazelcastException(msg);
        }
        InternalPartitionServiceImpl service = (InternalPartitionServiceImpl)this.getService();
        this.partitionState = service.createPartitionStateInternal();
    }

    @Override
    public ExceptionAction onInvocationException(Throwable throwable) {
        if (throwable instanceof MemberLeftException || throwable instanceof TargetNotMemberException) {
            return ExceptionAction.THROW_EXCEPTION;
        }
        return super.onInvocationException(throwable);
    }

    @Override
    public Object getResponse() {
        return this.partitionState;
    }

    @Override
    public String getServiceName() {
        return "hz:core:partitionService";
    }
}

