/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.internal.partition.operation;

import com.att.aft.dme2.hazelcast.core.MigrationEvent;
import com.att.aft.dme2.hazelcast.internal.partition.impl.InternalPartitionImpl;
import com.att.aft.dme2.hazelcast.internal.partition.impl.InternalPartitionServiceImpl;
import com.att.aft.dme2.hazelcast.internal.partition.impl.PartitionEventManager;
import com.att.aft.dme2.hazelcast.internal.partition.impl.PartitionStateManager;
import com.att.aft.dme2.hazelcast.internal.partition.operation.AbstractPromotionOperation;
import com.att.aft.dme2.hazelcast.logging.ILogger;
import com.att.aft.dme2.hazelcast.spi.MigrationAwareService;
import com.att.aft.dme2.hazelcast.spi.PartitionMigrationEvent;
import java.util.Arrays;

final class FinalizePromotionOperation
extends AbstractPromotionOperation {
    private final boolean success;
    private ILogger logger;

    FinalizePromotionOperation(int currentReplicaIndex, boolean success) {
        super(currentReplicaIndex);
        this.success = success;
    }

    private void initLogger() {
        this.logger = this.getLogger();
    }

    @Override
    public void beforeRun() throws Exception {
        this.initLogger();
    }

    @Override
    public void run() throws Exception {
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Running finalize promotion for " + this.getPartitionMigrationEvent() + ", result: " + this.success);
        }
        if (this.success) {
            this.shiftUpReplicaVersions();
            this.commitServices();
        } else {
            this.rollbackServices();
        }
    }

    @Override
    public void afterRun() throws Exception {
        this.clearPartitionMigratingFlag();
        MigrationEvent.MigrationStatus status = this.success ? MigrationEvent.MigrationStatus.COMPLETED : MigrationEvent.MigrationStatus.FAILED;
        this.sendMigrationEvent(status);
    }

    private void shiftUpReplicaVersions() {
        int partitionId = this.getPartitionId();
        try {
            InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
            long[] versions = partitionService.getPartitionReplicaVersions(partitionId);
            int lostReplicaIndex = this.currentReplicaIndex - 1;
            if (this.currentReplicaIndex > 1) {
                long[] versionsCopy = Arrays.copyOf(versions, versions.length);
                long version = versions[lostReplicaIndex];
                Arrays.fill(versions, 0, lostReplicaIndex, version);
                if (this.logger.isFinestEnabled()) {
                    this.logger.finest("Partition replica is lost! partitionId=" + partitionId + " lost replicaIndex=" + lostReplicaIndex + " replica versions before shift up=" + Arrays.toString(versionsCopy) + " replica versions after shift up=" + Arrays.toString(versions));
                }
            } else if (this.logger.isFinestEnabled()) {
                this.logger.finest("PROMOTE partitionId=" + this.getPartitionId() + " from currentReplicaIndex=" + this.currentReplicaIndex);
            }
            PartitionEventManager partitionEventManager = partitionService.getPartitionEventManager();
            partitionEventManager.sendPartitionLostEvent(partitionId, lostReplicaIndex);
        }
        catch (Throwable e) {
            this.logger.warning("Promotion failed. partitionId=" + partitionId + " replicaIndex=" + this.currentReplicaIndex, e);
        }
    }

    private void commitServices() {
        PartitionMigrationEvent event = this.getPartitionMigrationEvent();
        for (MigrationAwareService service : this.getMigrationAwareServices()) {
            try {
                service.commitMigration(event);
            }
            catch (Throwable e) {
                this.logger.warning("While promoting partitionId=" + this.getPartitionId(), e);
            }
        }
    }

    private void rollbackServices() {
        PartitionMigrationEvent event = this.getPartitionMigrationEvent();
        for (MigrationAwareService service : this.getMigrationAwareServices()) {
            try {
                service.rollbackMigration(event);
            }
            catch (Throwable e) {
                this.logger.warning("While promoting partitionId=" + this.getPartitionId(), e);
            }
        }
    }

    private void clearPartitionMigratingFlag() {
        InternalPartitionServiceImpl service = (InternalPartitionServiceImpl)this.getService();
        PartitionStateManager partitionStateManager = service.getPartitionStateManager();
        InternalPartitionImpl partition = partitionStateManager.getPartitionImpl(this.getPartitionId());
        partition.setMigrating(false);
    }
}

