/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.internal.partition.operation;

import com.att.aft.dme2.hazelcast.core.MemberLeftException;
import com.att.aft.dme2.hazelcast.instance.MemberImpl;
import com.att.aft.dme2.hazelcast.internal.partition.InternalPartition;
import com.att.aft.dme2.hazelcast.internal.partition.MigrationInfo;
import com.att.aft.dme2.hazelcast.internal.partition.impl.InternalMigrationListener;
import com.att.aft.dme2.hazelcast.internal.partition.impl.InternalPartitionServiceImpl;
import com.att.aft.dme2.hazelcast.internal.partition.impl.MigrationManager;
import com.att.aft.dme2.hazelcast.internal.partition.operation.BaseMigrationOperation;
import com.att.aft.dme2.hazelcast.internal.partition.operation.MigrationOperation;
import com.att.aft.dme2.hazelcast.nio.Address;
import com.att.aft.dme2.hazelcast.spi.ExceptionAction;
import com.att.aft.dme2.hazelcast.spi.MigrationAwareService;
import com.att.aft.dme2.hazelcast.spi.NodeEngine;
import com.att.aft.dme2.hazelcast.spi.Operation;
import com.att.aft.dme2.hazelcast.spi.PartitionMigrationEvent;
import com.att.aft.dme2.hazelcast.spi.PartitionReplicationEvent;
import com.att.aft.dme2.hazelcast.spi.exception.RetryableHazelcastException;
import com.att.aft.dme2.hazelcast.spi.exception.TargetNotMemberException;
import com.att.aft.dme2.hazelcast.spi.impl.NodeEngineImpl;
import com.att.aft.dme2.hazelcast.spi.impl.SimpleExecutionCallback;
import com.att.aft.dme2.hazelcast.spi.impl.servicemanager.ServiceInfo;
import com.att.aft.dme2.hazelcast.spi.partition.MigrationEndpoint;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;

public final class MigrationRequestOperation
extends BaseMigrationOperation {
    private boolean returnResponse = true;

    public MigrationRequestOperation() {
    }

    public MigrationRequestOperation(MigrationInfo migrationInfo, int partitionStateVersion) {
        super(migrationInfo, partitionStateVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        NodeEngine nodeEngine = this.getNodeEngine();
        this.verifyGoodMaster(nodeEngine);
        Address source = this.migrationInfo.getSource();
        Address destination = this.migrationInfo.getDestination();
        this.verifyExistingTarget(nodeEngine, destination);
        if (destination.equals(source)) {
            this.getLogger().warning("Source and destination addresses are the same! => " + this.toString());
            this.setFailed();
            return;
        }
        InternalPartition partition = this.getPartition();
        this.verifySource(nodeEngine.getThisAddress(), partition);
        if (!this.migrationInfo.startProcessing()) {
            this.getLogger().warning("Migration is cancelled -> " + this.migrationInfo);
            this.setFailed();
            return;
        }
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        MigrationManager migrationManager = partitionService.getMigrationManager();
        if (!migrationManager.addActiveMigration(this.migrationInfo)) {
            this.setFailed();
            return;
        }
        try {
            this.executeBeforeMigrations();
            Collection<Operation> tasks = this.prepareMigrationOperations();
            long[] replicaVersions = partitionService.getPartitionReplicaVersions(this.migrationInfo.getPartitionId());
            this.invokeMigrationOperation(destination, replicaVersions, tasks);
            this.returnResponse = false;
        }
        catch (Throwable e) {
            this.logThrowable(e);
            this.setFailed();
        }
        finally {
            this.migrationInfo.doneProcessing();
        }
    }

    private void setFailed() {
        this.success = false;
        this.onMigrationComplete(false);
    }

    @Override
    protected InternalMigrationListener.MigrationParticipant getMigrationParticipantType() {
        return InternalMigrationListener.MigrationParticipant.SOURCE;
    }

    private void logThrowable(Throwable t) {
        Throwable throwableToLog = t;
        if (throwableToLog instanceof ExecutionException) {
            throwableToLog = throwableToLog.getCause() != null ? throwableToLog.getCause() : throwableToLog;
        }
        Level level = this.getLogLevel(throwableToLog);
        this.getLogger().log(level, throwableToLog.getMessage(), throwableToLog);
    }

    private Level getLogLevel(Throwable e) {
        return e instanceof MemberLeftException || e instanceof InterruptedException || !this.getNodeEngine().isRunning() ? Level.INFO : Level.WARNING;
    }

    private void verifySource(Address thisAddress, InternalPartition partition) {
        Address owner = partition.getOwnerOrNull();
        if (owner == null) {
            throw new RetryableHazelcastException("Cannot migrate at the moment! Owner of the partition is null => " + this.migrationInfo);
        }
        if (!thisAddress.equals(owner)) {
            throw new RetryableHazelcastException("Owner of partition is not this node! => " + this.toString());
        }
    }

    private void invokeMigrationOperation(Address destination, long[] replicaVersions, Collection<Operation> tasks) throws IOException {
        MigrationOperation operation = new MigrationOperation(this.migrationInfo, replicaVersions, tasks, this.partitionStateVersion);
        NodeEngine nodeEngine = this.getNodeEngine();
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        nodeEngine.getOperationService().createInvocationBuilder("hz:core:partitionService", (Operation)operation, destination).setExecutionCallback(new MigrationCallback(this.migrationInfo, this)).setResultDeserialized(true).setCallTimeout(partitionService.getPartitionMigrationTimeout()).setTryCount(6).setTryPauseMillis(10000L).setReplicaIndex(this.getReplicaIndex()).invoke();
    }

    private void verifyGoodMaster(NodeEngine nodeEngine) {
        Address masterAddress = nodeEngine.getMasterAddress();
        if (!masterAddress.equals(this.migrationInfo.getMaster())) {
            throw new RetryableHazelcastException("Migration initiator is not master node! => " + this.toString());
        }
        if (!masterAddress.equals(this.getCallerAddress())) {
            throw new RetryableHazelcastException("Caller is not master node! => " + this.toString());
        }
    }

    private void verifyExistingTarget(NodeEngine nodeEngine, Address destination) {
        MemberImpl target = nodeEngine.getClusterService().getMember(destination);
        if (target == null) {
            throw new TargetNotMemberException("Destination of migration could not be found! => " + this.toString());
        }
    }

    @Override
    protected PartitionMigrationEvent getMigrationEvent() {
        return new PartitionMigrationEvent(MigrationEndpoint.SOURCE, this.migrationInfo.getPartitionId(), this.migrationInfo.getSourceCurrentReplicaIndex(), this.migrationInfo.getSourceNewReplicaIndex());
    }

    @Override
    public ExceptionAction onInvocationException(Throwable throwable) {
        if (throwable instanceof TargetNotMemberException) {
            return ExceptionAction.THROW_EXCEPTION;
        }
        return super.onInvocationException(throwable);
    }

    @Override
    public boolean returnsResponse() {
        return this.returnResponse;
    }

    private void handleMigrationResultFromTarget(Object result) {
        this.migrationInfo.doneProcessing();
        this.onMigrationComplete(Boolean.TRUE.equals(result));
        this.sendResponse(result);
    }

    @Override
    void executeBeforeMigrations() throws Exception {
        NodeEngine nodeEngine = this.getNodeEngine();
        boolean ownerMigration = nodeEngine.getThisAddress().equals(this.migrationInfo.getSource());
        if (!ownerMigration) {
            return;
        }
        super.executeBeforeMigrations();
    }

    private Collection<Operation> prepareMigrationOperations() {
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        PartitionReplicationEvent replicationEvent = new PartitionReplicationEvent(this.migrationInfo.getPartitionId(), this.migrationInfo.getDestinationNewReplicaIndex());
        LinkedList<Operation> tasks = new LinkedList<Operation>();
        for (ServiceInfo serviceInfo : nodeEngine.getServiceInfos(MigrationAwareService.class)) {
            MigrationAwareService service = (MigrationAwareService)serviceInfo.getService();
            Operation op = service.prepareReplicationOperation(replicationEvent);
            if (op == null) continue;
            op.setServiceName(serviceInfo.getName());
            tasks.add(op);
        }
        return tasks;
    }

    private static final class MigrationCallback
    extends SimpleExecutionCallback<Object> {
        final MigrationInfo migrationInfo;
        final MigrationRequestOperation op;

        private MigrationCallback(MigrationInfo migrationInfo, MigrationRequestOperation op) {
            this.migrationInfo = migrationInfo;
            this.op = op;
        }

        @Override
        public void notify(Object result) {
            this.op.handleMigrationResultFromTarget(result);
        }
    }
}

