/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.internal.partition.operation;

import com.att.aft.dme2.hazelcast.internal.cluster.impl.operations.JoinOperation;
import com.att.aft.dme2.hazelcast.internal.partition.MigrationCycleOperation;
import com.att.aft.dme2.hazelcast.internal.partition.PartitionRuntimeState;
import com.att.aft.dme2.hazelcast.internal.partition.impl.InternalPartitionServiceImpl;
import com.att.aft.dme2.hazelcast.logging.ILogger;
import com.att.aft.dme2.hazelcast.nio.Address;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.spi.AbstractOperation;
import java.io.IOException;

public final class PartitionStateOperation
extends AbstractOperation
implements MigrationCycleOperation,
JoinOperation {
    private PartitionRuntimeState partitionState;
    private boolean sync;
    private boolean success;

    public PartitionStateOperation() {
    }

    public PartitionStateOperation(PartitionRuntimeState partitionState) {
        this(partitionState, false);
    }

    public PartitionStateOperation(PartitionRuntimeState partitionState, boolean sync) {
        this.partitionState = partitionState;
        this.sync = sync;
    }

    @Override
    public void run() {
        Address callerAddress = this.getCallerAddress();
        this.partitionState.setEndpoint(callerAddress);
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        this.success = partitionService.processPartitionRuntimeState(this.partitionState);
        ILogger logger = this.getLogger();
        if (logger.isFineEnabled()) {
            logger.fine("Applied new partition state: " + this.success + ". Version: " + this.partitionState.getVersion() + ", caller: " + callerAddress);
        }
    }

    @Override
    public boolean returnsResponse() {
        return this.sync;
    }

    @Override
    public Object getResponse() {
        return this.success;
    }

    @Override
    public String getServiceName() {
        return "hz:core:partitionService";
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.partitionState = new PartitionRuntimeState();
        this.partitionState.readData(in);
        this.sync = in.readBoolean();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        this.partitionState.writeData(out);
        out.writeBoolean(this.sync);
    }
}

