/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.internal.partition.operation;

import com.att.aft.dme2.hazelcast.internal.partition.MigrationCycleOperation;
import com.att.aft.dme2.hazelcast.internal.partition.ReplicaErrorLogger;
import com.att.aft.dme2.hazelcast.internal.partition.impl.InternalPartitionImpl;
import com.att.aft.dme2.hazelcast.internal.partition.impl.InternalPartitionServiceImpl;
import com.att.aft.dme2.hazelcast.internal.partition.impl.PartitionStateManager;
import com.att.aft.dme2.hazelcast.logging.ILogger;
import com.att.aft.dme2.hazelcast.nio.Address;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.spi.BackupOperation;
import com.att.aft.dme2.hazelcast.spi.Operation;
import com.att.aft.dme2.hazelcast.spi.PartitionAwareOperation;
import java.io.IOException;

public class ReplicaSyncRetryResponse
extends Operation
implements PartitionAwareOperation,
BackupOperation,
MigrationCycleOperation {
    @Override
    public void beforeRun() throws Exception {
    }

    @Override
    public void run() throws Exception {
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        int partitionId = this.getPartitionId();
        int replicaIndex = this.getReplicaIndex();
        partitionService.getReplicaManager().clearReplicaSyncRequest(partitionId, replicaIndex);
        PartitionStateManager partitionStateManager = partitionService.getPartitionStateManager();
        InternalPartitionImpl partition = partitionStateManager.getPartitionImpl(partitionId);
        Address thisAddress = this.getNodeEngine().getThisAddress();
        ILogger logger = this.getLogger();
        int currentReplicaIndex = partition.getReplicaIndex(thisAddress);
        if (currentReplicaIndex > 0) {
            if (logger.isFinestEnabled()) {
                logger.finest("Retrying replica sync request for partitionId=" + partitionId + ", initial-replicaIndex=" + replicaIndex + ", current-replicaIndex=" + currentReplicaIndex);
            }
            partitionService.getReplicaManager().triggerPartitionReplicaSync(partitionId, currentReplicaIndex, 500L);
        } else if (logger.isFinestEnabled()) {
            logger.finest("No need to retry replica sync request for partitionId=" + partitionId + ", initial-replicaIndex=" + replicaIndex + ", current-replicaIndex=" + currentReplicaIndex);
        }
    }

    @Override
    public void afterRun() throws Exception {
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public Object getResponse() {
        return null;
    }

    @Override
    public boolean validatesTarget() {
        return false;
    }

    @Override
    public String getServiceName() {
        return "hz:core:partitionService";
    }

    @Override
    public void logError(Throwable e) {
        ReplicaErrorLogger.log(e, this.getLogger());
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
    }
}

