/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.internal.partition.operation;

import com.att.aft.dme2.hazelcast.internal.cluster.ClusterService;
import com.att.aft.dme2.hazelcast.internal.partition.MigrationCycleOperation;
import com.att.aft.dme2.hazelcast.internal.partition.impl.InternalPartitionServiceImpl;
import com.att.aft.dme2.hazelcast.logging.ILogger;
import com.att.aft.dme2.hazelcast.nio.Address;
import com.att.aft.dme2.hazelcast.spi.NodeEngine;
import com.att.aft.dme2.hazelcast.spi.Operation;

public class ShutdownRequestOperation
extends Operation
implements MigrationCycleOperation {
    @Override
    public void run() {
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        ILogger logger = this.getLogger();
        Address caller = this.getCallerAddress();
        NodeEngine nodeEngine = this.getNodeEngine();
        ClusterService clusterService = nodeEngine.getClusterService();
        if (clusterService.isMaster()) {
            if (clusterService.getMember(caller) != null) {
                if (logger.isFinestEnabled()) {
                    logger.finest("Received shutdown request from " + caller);
                }
                partitionService.onShutdownRequest(caller);
            } else {
                logger.warning("Ignoring shutdown request from " + caller + " because it is not a member");
            }
        } else {
            logger.warning("Received shutdown request from " + caller + " but this node is not master.");
        }
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public String getServiceName() {
        return "hz:core:partitionService";
    }
}

