/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.internal.partition.operation;

import com.att.aft.dme2.hazelcast.internal.cluster.ClusterService;
import com.att.aft.dme2.hazelcast.internal.partition.MigrationCycleOperation;
import com.att.aft.dme2.hazelcast.internal.partition.impl.InternalPartitionServiceImpl;
import com.att.aft.dme2.hazelcast.logging.ILogger;
import com.att.aft.dme2.hazelcast.nio.Address;
import com.att.aft.dme2.hazelcast.spi.NodeEngine;
import com.att.aft.dme2.hazelcast.spi.Operation;

public class ShutdownResponseOperation
extends Operation
implements MigrationCycleOperation {
    @Override
    public void run() {
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        ILogger logger = this.getLogger();
        Address caller = this.getCallerAddress();
        NodeEngine nodeEngine = this.getNodeEngine();
        ClusterService clusterService = nodeEngine.getClusterService();
        Address masterAddress = clusterService.getMasterAddress();
        if (nodeEngine.isRunning()) {
            logger.severe("Received a shutdown response from " + caller + ", but this node is not shutting down!");
            return;
        }
        boolean fromMaster = masterAddress.equals(caller);
        if (fromMaster) {
            if (logger.isFinestEnabled()) {
                logger.finest("Received shutdown response from " + caller);
            }
            partitionService.onShutdownResponse();
        } else {
            logger.warning("Received shutdown response from " + caller + " but known master is: " + masterAddress);
        }
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public String getServiceName() {
        return "hz:core:partitionService";
    }
}

