/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.internal.serialization.impl.bufferpool;

import com.att.aft.dme2.hazelcast.core.HazelcastInstanceNotActiveException;
import com.att.aft.dme2.hazelcast.internal.serialization.InternalSerializationService;
import com.att.aft.dme2.hazelcast.internal.serialization.impl.bufferpool.BufferPool;
import com.att.aft.dme2.hazelcast.internal.serialization.impl.bufferpool.BufferPoolFactory;
import com.att.aft.dme2.hazelcast.util.ConcurrentReferenceHashMap;
import java.lang.ref.WeakReference;
import java.util.Map;

public final class BufferPoolThreadLocal {
    private final ThreadLocal<WeakReference<BufferPool>> threadLocal = new ThreadLocal();
    private final InternalSerializationService serializationService;
    private final BufferPoolFactory bufferPoolFactory;
    private final Map<Thread, BufferPool> strongReferences = new ConcurrentReferenceHashMap<Thread, BufferPool>(ConcurrentReferenceHashMap.ReferenceType.WEAK, ConcurrentReferenceHashMap.ReferenceType.STRONG);

    public BufferPoolThreadLocal(InternalSerializationService serializationService, BufferPoolFactory bufferPoolFactory) {
        this.serializationService = serializationService;
        this.bufferPoolFactory = bufferPoolFactory;
    }

    public BufferPool get() {
        WeakReference<BufferPool> ref = this.threadLocal.get();
        if (ref == null) {
            BufferPool pool = this.bufferPoolFactory.create(this.serializationService);
            ref = new WeakReference<BufferPool>(pool);
            this.strongReferences.put(Thread.currentThread(), pool);
            this.threadLocal.set(ref);
            return pool;
        }
        BufferPool pool = (BufferPool)ref.get();
        if (pool == null) {
            throw new HazelcastInstanceNotActiveException();
        }
        return pool;
    }

    public void clear() {
        this.strongReferences.clear();
    }
}

