/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.map.impl;

import com.att.aft.dme2.hazelcast.map.impl.AbstractMapServiceFactory;
import com.att.aft.dme2.hazelcast.map.impl.MapClientAwareService;
import com.att.aft.dme2.hazelcast.map.impl.MapManagedService;
import com.att.aft.dme2.hazelcast.map.impl.MapMigrationAwareService;
import com.att.aft.dme2.hazelcast.map.impl.MapPartitionAwareService;
import com.att.aft.dme2.hazelcast.map.impl.MapPostJoinAwareService;
import com.att.aft.dme2.hazelcast.map.impl.MapQuorumAwareService;
import com.att.aft.dme2.hazelcast.map.impl.MapRemoteService;
import com.att.aft.dme2.hazelcast.map.impl.MapReplicationSupportingService;
import com.att.aft.dme2.hazelcast.map.impl.MapServiceContext;
import com.att.aft.dme2.hazelcast.map.impl.MapSplitBrainHandlerService;
import com.att.aft.dme2.hazelcast.map.impl.MapStatisticsAwareService;
import com.att.aft.dme2.hazelcast.map.impl.MapTransactionalService;
import com.att.aft.dme2.hazelcast.map.impl.event.MapEventPublishingService;
import com.att.aft.dme2.hazelcast.spi.ClientAwareService;
import com.att.aft.dme2.hazelcast.spi.EventPublishingService;
import com.att.aft.dme2.hazelcast.spi.ManagedService;
import com.att.aft.dme2.hazelcast.spi.PostJoinAwareService;
import com.att.aft.dme2.hazelcast.spi.QuorumAwareService;
import com.att.aft.dme2.hazelcast.spi.RemoteService;
import com.att.aft.dme2.hazelcast.spi.ReplicationSupportingService;
import com.att.aft.dme2.hazelcast.spi.SplitBrainHandlerService;
import com.att.aft.dme2.hazelcast.spi.StatisticsAwareService;
import com.att.aft.dme2.hazelcast.spi.TransactionalService;
import com.att.aft.dme2.hazelcast.spi.impl.DelegatingMigrationAwareService;
import com.att.aft.dme2.hazelcast.util.Preconditions;

class DefaultMapServiceFactory
extends AbstractMapServiceFactory {
    private final MapServiceContext mapServiceContext;

    public DefaultMapServiceFactory(MapServiceContext mapServiceContext) {
        this.mapServiceContext = Preconditions.checkNotNull(mapServiceContext, "mapServiceContext should not be null");
    }

    @Override
    public MapServiceContext getMapServiceContext() {
        return this.mapServiceContext;
    }

    @Override
    ManagedService createManagedService() {
        return new MapManagedService(this.mapServiceContext);
    }

    @Override
    DelegatingMigrationAwareService createMigrationAwareService() {
        return new DelegatingMigrationAwareService(new MapMigrationAwareService(this.mapServiceContext));
    }

    @Override
    TransactionalService createTransactionalService() {
        return new MapTransactionalService(this.mapServiceContext);
    }

    @Override
    RemoteService createRemoteService() {
        return new MapRemoteService(this.mapServiceContext);
    }

    @Override
    EventPublishingService createEventPublishingService() {
        return new MapEventPublishingService(this.mapServiceContext);
    }

    @Override
    PostJoinAwareService createPostJoinAwareService() {
        return new MapPostJoinAwareService(this.mapServiceContext);
    }

    @Override
    SplitBrainHandlerService createSplitBrainHandlerService() {
        return new MapSplitBrainHandlerService(this.mapServiceContext);
    }

    @Override
    ReplicationSupportingService createReplicationSupportingService() {
        return new MapReplicationSupportingService(this.mapServiceContext);
    }

    @Override
    StatisticsAwareService createStatisticsAwareService() {
        return new MapStatisticsAwareService(this.mapServiceContext);
    }

    @Override
    MapPartitionAwareService createPartitionAwareService() {
        return new MapPartitionAwareService(this.mapServiceContext);
    }

    @Override
    QuorumAwareService createQuorumAwareService() {
        return new MapQuorumAwareService(this.getMapServiceContext());
    }

    @Override
    ClientAwareService createClientAwareService() {
        return new MapClientAwareService();
    }
}

