/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.map.impl;

import com.att.aft.dme2.hazelcast.core.EntryEventType;
import com.att.aft.dme2.hazelcast.core.IMapEvent;
import com.att.aft.dme2.hazelcast.map.impl.ListenerAdapter;
import com.att.aft.dme2.hazelcast.map.impl.MapListenerAdaptors;
import com.att.aft.dme2.hazelcast.map.listener.MapListener;
import com.att.aft.dme2.hazelcast.util.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

public class InternalMapListenerAdapter
implements ListenerAdapter<IMapEvent> {
    private final ListenerAdapter[] listenerAdapters;

    InternalMapListenerAdapter(MapListener mapListener) {
        Preconditions.isNotNull(mapListener, "mapListener");
        this.listenerAdapters = MapListenerAdaptors.createListenerAdapters(mapListener);
    }

    @Override
    public void onEvent(IMapEvent event) {
        EntryEventType eventType = event.getEventType();
        if (eventType == null) {
            return;
        }
        ListenerAdapter listenerAdapter = this.listenerAdapters[eventType.ordinal()];
        if (listenerAdapter == null) {
            return;
        }
        listenerAdapter.onEvent(event);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="listenerAdapters internal state is never changed")
    public ListenerAdapter[] getListenerAdapters() {
        return this.listenerAdapters;
    }
}

