/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.map.impl;

import com.att.aft.dme2.hazelcast.concurrent.lock.LockService;
import com.att.aft.dme2.hazelcast.concurrent.lock.LockStoreInfo;
import com.att.aft.dme2.hazelcast.map.impl.MapContainer;
import com.att.aft.dme2.hazelcast.map.impl.MapServiceContext;
import com.att.aft.dme2.hazelcast.spi.ManagedService;
import com.att.aft.dme2.hazelcast.spi.NodeEngine;
import com.att.aft.dme2.hazelcast.spi.ObjectNamespace;
import com.att.aft.dme2.hazelcast.util.ConstructorFunction;
import java.util.Properties;

public class MapManagedService
implements ManagedService {
    private final MapServiceContext mapServiceContext;

    MapManagedService(MapServiceContext mapServiceContext) {
        this.mapServiceContext = mapServiceContext;
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        LockService lockService = (LockService)nodeEngine.getSharedService("hz:impl:lockService");
        if (lockService != null) {
            lockService.registerLockStoreConstructor("hz:impl:mapService", new ObjectNamespaceLockStoreInfoConstructorFunction());
        }
        this.mapServiceContext.initPartitionsContainers();
        this.mapServiceContext.getExpirationManager().start();
    }

    @Override
    public void reset() {
        this.mapServiceContext.reset();
    }

    @Override
    public void shutdown(boolean terminate) {
        if (!terminate) {
            this.mapServiceContext.flushMaps();
            this.mapServiceContext.destroyMapStores();
        }
        this.mapServiceContext.shutdown();
    }

    private class ObjectNamespaceLockStoreInfoConstructorFunction
    implements ConstructorFunction<ObjectNamespace, LockStoreInfo> {
        private ObjectNamespaceLockStoreInfoConstructorFunction() {
        }

        @Override
        public LockStoreInfo createNew(ObjectNamespace key) {
            final MapContainer mapContainer = MapManagedService.this.mapServiceContext.getMapContainer(key.getObjectName());
            return new LockStoreInfo(){

                @Override
                public int getBackupCount() {
                    return mapContainer.getBackupCount();
                }

                @Override
                public int getAsyncBackupCount() {
                    return mapContainer.getAsyncBackupCount();
                }
            };
        }
    }
}

