/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.map.impl;

import com.att.aft.dme2.hazelcast.map.impl.MapContainer;
import com.att.aft.dme2.hazelcast.map.impl.MapServiceContext;
import com.att.aft.dme2.hazelcast.map.impl.PartitionContainer;
import com.att.aft.dme2.hazelcast.map.impl.operation.MapReplicationOperation;
import com.att.aft.dme2.hazelcast.map.impl.record.Record;
import com.att.aft.dme2.hazelcast.map.impl.record.Records;
import com.att.aft.dme2.hazelcast.map.impl.recordstore.RecordStore;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.query.impl.Indexes;
import com.att.aft.dme2.hazelcast.query.impl.QueryableEntry;
import com.att.aft.dme2.hazelcast.spi.MigrationAwareService;
import com.att.aft.dme2.hazelcast.spi.Operation;
import com.att.aft.dme2.hazelcast.spi.PartitionMigrationEvent;
import com.att.aft.dme2.hazelcast.spi.PartitionReplicationEvent;
import com.att.aft.dme2.hazelcast.spi.partition.MigrationEndpoint;
import com.att.aft.dme2.hazelcast.spi.serialization.SerializationService;
import com.att.aft.dme2.hazelcast.util.Clock;
import java.util.Iterator;

class MapMigrationAwareService
implements MigrationAwareService {
    protected final MapServiceContext mapServiceContext;
    protected final SerializationService serializationService;

    MapMigrationAwareService(MapServiceContext mapServiceContext) {
        this.mapServiceContext = mapServiceContext;
        this.serializationService = mapServiceContext.getNodeEngine().getSerializationService();
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent event) {
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event) {
        int partitionId = event.getPartitionId();
        PartitionContainer container = this.mapServiceContext.getPartitionContainer(partitionId);
        MapReplicationOperation operation = new MapReplicationOperation(container, partitionId, event.getReplicaIndex());
        operation.setService(this.mapServiceContext.getService());
        return operation;
    }

    @Override
    public void commitMigration(PartitionMigrationEvent event) {
        this.migrateIndex(event);
        if (event.getMigrationEndpoint() == MigrationEndpoint.SOURCE) {
            this.clearMapsHavingLesserBackupCountThan(event.getPartitionId(), event.getNewReplicaIndex());
        }
        PartitionContainer partitionContainer = this.mapServiceContext.getPartitionContainer(event.getPartitionId());
        for (RecordStore recordStore : partitionContainer.getAllRecordStores()) {
            recordStore.startLoading();
        }
        this.mapServiceContext.reloadOwnedPartitions();
    }

    @Override
    public void rollbackMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.DESTINATION) {
            this.clearMapsHavingLesserBackupCountThan(event.getPartitionId(), event.getCurrentReplicaIndex());
        }
        this.mapServiceContext.reloadOwnedPartitions();
    }

    private void clearMapsHavingLesserBackupCountThan(int partitionId, int thresholdReplicaIndex) {
        if (thresholdReplicaIndex < 0) {
            this.mapServiceContext.clearPartitionData(partitionId);
        } else {
            this.mapServiceContext.clearMapsHavingLesserBackupCountThan(partitionId, thresholdReplicaIndex);
        }
    }

    private void migrateIndex(PartitionMigrationEvent event) {
        long now = this.getNow();
        PartitionContainer container = this.mapServiceContext.getPartitionContainer(event.getPartitionId());
        for (RecordStore recordStore : container.getMaps().values()) {
            MapContainer mapContainer = this.mapServiceContext.getMapContainer(recordStore.getName());
            Indexes indexes = mapContainer.getIndexes();
            if (!indexes.hasIndex()) continue;
            Iterator<Record> iterator = recordStore.iterator(now, false);
            while (iterator.hasNext()) {
                Object value;
                Record record = iterator.next();
                Data key = record.getKey();
                if (event.getMigrationEndpoint() == MigrationEndpoint.SOURCE) {
                    assert (event.getNewReplicaIndex() != 0) : "Invalid migration event: " + event;
                    value = Records.getValueOrCachedValue(record, this.serializationService);
                    indexes.removeEntryIndex(key, value);
                    continue;
                }
                if (event.getNewReplicaIndex() != 0 || (value = Records.getValueOrCachedValue(record, this.serializationService)) == null) continue;
                QueryableEntry queryEntry = mapContainer.newQueryEntry(record.getKey(), value);
                indexes.saveEntryIndex(queryEntry, null);
            }
        }
    }

    protected long getNow() {
        return Clock.currentTimeMillis();
    }
}

