/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.map.impl;

import com.att.aft.dme2.hazelcast.config.MapConfig;
import com.att.aft.dme2.hazelcast.core.DistributedObject;
import com.att.aft.dme2.hazelcast.map.impl.MapConfigValidator;
import com.att.aft.dme2.hazelcast.map.impl.MapServiceContext;
import com.att.aft.dme2.hazelcast.map.impl.proxy.MapProxyImpl;
import com.att.aft.dme2.hazelcast.map.impl.proxy.NearCachedMapProxyImpl;
import com.att.aft.dme2.hazelcast.spi.NodeEngine;
import com.att.aft.dme2.hazelcast.spi.RemoteService;

class MapRemoteService
implements RemoteService {
    protected final MapServiceContext mapServiceContext;
    protected final NodeEngine nodeEngine;

    MapRemoteService(MapServiceContext mapServiceContext) {
        this.mapServiceContext = mapServiceContext;
        this.nodeEngine = mapServiceContext.getNodeEngine();
    }

    @Override
    public DistributedObject createDistributedObject(String name) {
        MapConfig mapConfig = this.nodeEngine.getConfig().findMapConfig(name);
        MapConfigValidator.checkMapConfig(mapConfig);
        if (mapConfig.isNearCacheEnabled()) {
            MapConfigValidator.checkNotNative(mapConfig.getNearCacheConfig().getInMemoryFormat());
            return new NearCachedMapProxyImpl(name, this.mapServiceContext.getService(), this.nodeEngine, mapConfig);
        }
        return new MapProxyImpl(name, this.mapServiceContext.getService(), this.nodeEngine, mapConfig);
    }

    @Override
    public void destroyDistributedObject(String name) {
        this.mapServiceContext.destroyMap(name);
    }
}

