/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.map.impl;

import com.att.aft.dme2.hazelcast.core.EntryView;
import com.att.aft.dme2.hazelcast.map.impl.MapContainer;
import com.att.aft.dme2.hazelcast.map.impl.MapServiceContext;
import com.att.aft.dme2.hazelcast.map.impl.operation.MapOperation;
import com.att.aft.dme2.hazelcast.map.impl.operation.MapOperationProvider;
import com.att.aft.dme2.hazelcast.map.impl.wan.MapReplicationRemove;
import com.att.aft.dme2.hazelcast.map.impl.wan.MapReplicationUpdate;
import com.att.aft.dme2.hazelcast.map.merge.MapMergePolicy;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.spi.InternalCompletableFuture;
import com.att.aft.dme2.hazelcast.spi.NodeEngine;
import com.att.aft.dme2.hazelcast.spi.ReplicationSupportingService;
import com.att.aft.dme2.hazelcast.util.ExceptionUtil;
import com.att.aft.dme2.hazelcast.wan.ReplicationEventObject;
import com.att.aft.dme2.hazelcast.wan.WanReplicationEvent;

class MapReplicationSupportingService
implements ReplicationSupportingService {
    private final MapServiceContext mapServiceContext;
    private final NodeEngine nodeEngine;

    MapReplicationSupportingService(MapServiceContext mapServiceContext) {
        this.mapServiceContext = mapServiceContext;
        this.nodeEngine = mapServiceContext.getNodeEngine();
    }

    @Override
    public void onReplicationEvent(WanReplicationEvent replicationEvent) {
        ReplicationEventObject eventObject = replicationEvent.getEventObject();
        if (eventObject instanceof MapReplicationUpdate) {
            this.handleUpdate((MapReplicationUpdate)eventObject);
        } else if (eventObject instanceof MapReplicationRemove) {
            this.handleRemove((MapReplicationRemove)eventObject);
        }
    }

    private void handleRemove(MapReplicationRemove replicationRemove) {
        String mapName = replicationRemove.getMapName();
        MapOperationProvider operationProvider = this.mapServiceContext.getMapOperationProvider(mapName);
        MapOperation operation = operationProvider.createRemoveOperation(replicationRemove.getMapName(), replicationRemove.getKey(), true);
        try {
            int partitionId = this.nodeEngine.getPartitionService().getPartitionId(replicationRemove.getKey());
            InternalCompletableFuture f = this.nodeEngine.getOperationService().invokeOnPartition("hz:impl:mapService", operation, partitionId);
            f.get();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    private void handleUpdate(MapReplicationUpdate replicationUpdate) {
        EntryView entryView = replicationUpdate.getEntryView();
        MapMergePolicy mergePolicy = replicationUpdate.getMergePolicy();
        String mapName = replicationUpdate.getMapName();
        MapContainer mapContainer = this.mapServiceContext.getMapContainer(mapName);
        MapOperationProvider operationProvider = this.mapServiceContext.getMapOperationProvider(mapName);
        Data dataKey = this.mapServiceContext.toData(entryView.getKey(), mapContainer.getPartitioningStrategy());
        MapOperation operation = operationProvider.createMergeOperation(mapName, dataKey, entryView, mergePolicy, true);
        try {
            int partitionId = this.nodeEngine.getPartitionService().getPartitionId(entryView.getKey());
            InternalCompletableFuture f = this.nodeEngine.getOperationService().invokeOnPartition("hz:impl:mapService", operation, partitionId);
            f.get();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }
}

