/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.map.impl;

import com.att.aft.dme2.hazelcast.core.DistributedObject;
import com.att.aft.dme2.hazelcast.map.impl.LocalMapStatsProvider;
import com.att.aft.dme2.hazelcast.map.impl.MapServiceContext;
import com.att.aft.dme2.hazelcast.monitor.LocalMapStats;
import com.att.aft.dme2.hazelcast.spi.ProxyService;
import com.att.aft.dme2.hazelcast.spi.StatisticsAwareService;
import com.att.aft.dme2.hazelcast.util.MapUtil;
import java.util.Collection;
import java.util.Map;

class MapStatisticsAwareService
implements StatisticsAwareService {
    private final MapServiceContext mapServiceContext;
    private final ProxyService proxyService;

    MapStatisticsAwareService(MapServiceContext mapServiceContext) {
        this.mapServiceContext = mapServiceContext;
        this.proxyService = mapServiceContext.getNodeEngine().getProxyService();
    }

    public Map<String, LocalMapStats> getStats() {
        MapServiceContext mapServiceContext = this.mapServiceContext;
        Collection<DistributedObject> mapProxies = this.proxyService.getDistributedObjects("hz:impl:mapService");
        Map<String, LocalMapStats> mapStats = MapUtil.createHashMap(mapProxies.size());
        for (DistributedObject mapProxy : mapProxies) {
            LocalMapStatsProvider localMapStatsProvider = mapServiceContext.getLocalMapStatsProvider();
            mapStats.put(mapProxy.getName(), localMapStatsProvider.createLocalMapStats(mapProxy.getName()));
        }
        return mapStats;
    }
}

