/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.map.impl.event;

import com.att.aft.dme2.hazelcast.internal.serialization.InternalSerializationService;
import com.att.aft.dme2.hazelcast.map.impl.EntryEventFilter;
import com.att.aft.dme2.hazelcast.map.impl.MapServiceContext;
import com.att.aft.dme2.hazelcast.map.impl.event.FilteringStrategy;
import com.att.aft.dme2.hazelcast.map.impl.query.QueryEventFilter;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.query.impl.CachedQueryEntry;
import com.att.aft.dme2.hazelcast.query.impl.getters.Extractors;
import com.att.aft.dme2.hazelcast.spi.EventFilter;
import com.att.aft.dme2.hazelcast.spi.serialization.SerializationService;

public abstract class AbstractFilteringStrategy
implements FilteringStrategy {
    protected final SerializationService serializationService;
    protected final MapServiceContext mapServiceContext;

    public AbstractFilteringStrategy(SerializationService serializationService, MapServiceContext mapServiceContext) {
        this.serializationService = serializationService;
        this.mapServiceContext = mapServiceContext;
    }

    protected String getThisNodesAddress() {
        return this.mapServiceContext.getNodeEngine().getThisAddress().toString();
    }

    protected boolean processEntryEventFilter(EventFilter filter, Data dataKey) {
        EntryEventFilter eventFilter = (EntryEventFilter)filter;
        return eventFilter.eval(dataKey);
    }

    protected boolean evaluateQueryEventFilter(EventFilter filter, Data dataKey, Object testValue, String mapNameOrNull) {
        Extractors extractors = this.getExtractorsForMapName(mapNameOrNull);
        QueryEventFilter queryEventFilter = (QueryEventFilter)filter;
        CachedQueryEntry entry = new CachedQueryEntry((InternalSerializationService)this.serializationService, dataKey, testValue, extractors);
        return queryEventFilter.eval(entry);
    }

    private Extractors getExtractorsForMapName(String mapNameOrNull) {
        if (mapNameOrNull == null) {
            return Extractors.empty();
        }
        return this.mapServiceContext.getExtractors(mapNameOrNull);
    }
}

