/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.map.impl.iterator;

import com.att.aft.dme2.hazelcast.map.impl.MapDataSerializerHook;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MapEntriesWithCursor
implements IdentifiedDataSerializable {
    private List<Map.Entry<Data, Data>> entries;
    private int nextTableIndexToReadFrom;

    public MapEntriesWithCursor() {
    }

    public MapEntriesWithCursor(List<Map.Entry<Data, Data>> entries, int nextTableIndexToReadFrom) {
        this.entries = entries;
        this.nextTableIndexToReadFrom = nextTableIndexToReadFrom;
    }

    public List<Map.Entry<Data, Data>> getEntries() {
        return this.entries;
    }

    public int getNextTableIndexToReadFrom() {
        return this.nextTableIndexToReadFrom;
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 14;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.nextTableIndexToReadFrom);
        int size = this.entries.size();
        out.writeInt(size);
        for (Map.Entry<Data, Data> entry : this.entries) {
            out.writeData(entry.getKey());
            out.writeData(entry.getValue());
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.nextTableIndexToReadFrom = in.readInt();
        int size = in.readInt();
        this.entries = new ArrayList<Map.Entry<Data, Data>>(size);
        for (int i = 0; i < size; ++i) {
            Data key = in.readData();
            Data value = in.readData();
            this.entries.add(new AbstractMap.SimpleEntry<Data, Data>(key, value));
        }
    }
}

