/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.map.impl.iterator;

import com.att.aft.dme2.hazelcast.map.impl.MapDataSerializerHook;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MapKeysWithCursor
implements IdentifiedDataSerializable {
    private int nextTableIndexToReadFrom;
    private List<Data> keys;

    public MapKeysWithCursor() {
    }

    public MapKeysWithCursor(List<Data> keys, int nextTableIndexToReadFrom) {
        this.keys = keys;
        this.nextTableIndexToReadFrom = nextTableIndexToReadFrom;
    }

    public int getNextTableIndexToReadFrom() {
        return this.nextTableIndexToReadFrom;
    }

    public List<Data> getKeys() {
        return this.keys;
    }

    public int getCount() {
        return this.keys != null ? this.keys.size() : 0;
    }

    public Data getKey(int index) {
        return this.keys != null ? this.keys.get(index) : null;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.nextTableIndexToReadFrom);
        int size = this.keys.size();
        out.writeInt(size);
        for (Data o : this.keys) {
            out.writeData(o);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.nextTableIndexToReadFrom = in.readInt();
        int size = in.readInt();
        this.keys = new ArrayList<Data>(size);
        for (int i = 0; i < size; ++i) {
            Data data = in.readData();
            this.keys.add(data);
        }
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 13;
    }
}

