/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.map.impl.iterator;

import com.att.aft.dme2.hazelcast.map.impl.iterator.AbstractMapPartitionIterator;
import com.att.aft.dme2.hazelcast.map.impl.iterator.MapEntriesWithCursor;
import com.att.aft.dme2.hazelcast.map.impl.iterator.MapKeysWithCursor;
import com.att.aft.dme2.hazelcast.map.impl.operation.MapOperation;
import com.att.aft.dme2.hazelcast.map.impl.operation.MapOperationProvider;
import com.att.aft.dme2.hazelcast.map.impl.proxy.MapProxyImpl;
import com.att.aft.dme2.hazelcast.spi.InternalCompletableFuture;
import com.att.aft.dme2.hazelcast.spi.OperationService;
import com.att.aft.dme2.hazelcast.spi.serialization.SerializationService;
import java.util.List;

public class MapPartitionIterator<K, V>
extends AbstractMapPartitionIterator<K, V> {
    private final MapProxyImpl<K, V> mapProxy;

    public MapPartitionIterator(MapProxyImpl<K, V> mapProxy, int fetchSize, int partitionId, boolean prefetchValues) {
        super(mapProxy, fetchSize, partitionId, prefetchValues);
        this.mapProxy = mapProxy;
        this.advance();
    }

    @Override
    protected List fetch() {
        String name = this.mapProxy.getName();
        String serviceName = this.mapProxy.getServiceName();
        MapOperationProvider operationProvider = this.mapProxy.getOperationProvider();
        OperationService operationService = this.mapProxy.getOperationService();
        if (this.prefetchValues) {
            MapOperation operation = operationProvider.createFetchEntriesOperation(name, this.lastTableIndex, this.fetchSize);
            InternalCompletableFuture future = operationService.invokeOnPartition(serviceName, operation, this.partitionId);
            MapEntriesWithCursor mapEntriesWithCursor = (MapEntriesWithCursor)future.join();
            this.setLastTableIndex(mapEntriesWithCursor.getEntries(), mapEntriesWithCursor.getNextTableIndexToReadFrom());
            return mapEntriesWithCursor.getEntries();
        }
        MapOperation operation = operationProvider.createFetchKeysOperation(name, this.lastTableIndex, this.fetchSize);
        InternalCompletableFuture future = operationService.invokeOnPartition(serviceName, operation, this.partitionId);
        MapKeysWithCursor mapKeysWithCursor = (MapKeysWithCursor)future.join();
        this.setLastTableIndex(mapKeysWithCursor.getKeys(), mapKeysWithCursor.getNextTableIndexToReadFrom());
        return mapKeysWithCursor.getKeys();
    }

    @Override
    protected SerializationService getSerializationService() {
        return this.mapProxy.getNodeEngine().getSerializationService();
    }
}

