/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.map.impl.mapstore;

import com.att.aft.dme2.hazelcast.config.MapStoreConfig;
import com.att.aft.dme2.hazelcast.map.impl.MapServiceContext;
import com.att.aft.dme2.hazelcast.map.impl.MapStoreWrapper;
import com.att.aft.dme2.hazelcast.map.impl.mapstore.EmptyMapDataStore;
import com.att.aft.dme2.hazelcast.map.impl.mapstore.MapDataStore;
import com.att.aft.dme2.hazelcast.map.impl.mapstore.MapStoreContext;
import com.att.aft.dme2.hazelcast.map.impl.mapstore.writebehind.WriteBehindProcessor;
import com.att.aft.dme2.hazelcast.map.impl.mapstore.writebehind.WriteBehindQueue;
import com.att.aft.dme2.hazelcast.map.impl.mapstore.writebehind.WriteBehindQueues;
import com.att.aft.dme2.hazelcast.map.impl.mapstore.writebehind.WriteBehindStore;
import com.att.aft.dme2.hazelcast.map.impl.mapstore.writethrough.WriteThroughStore;
import com.att.aft.dme2.hazelcast.spi.NodeEngine;
import com.att.aft.dme2.hazelcast.spi.properties.GroupProperty;
import com.att.aft.dme2.hazelcast.spi.properties.HazelcastProperties;
import com.att.aft.dme2.hazelcast.spi.serialization.SerializationService;
import java.util.concurrent.atomic.AtomicInteger;

public final class MapDataStores {
    public static final MapDataStore EMPTY_MAP_DATA_STORE = new EmptyMapDataStore();

    private MapDataStores() {
    }

    public static <K, V> MapDataStore<K, V> createWriteBehindStore(MapStoreContext mapStoreContext, int partitionId, WriteBehindProcessor writeBehindProcessor) {
        MapServiceContext mapServiceContext = mapStoreContext.getMapServiceContext();
        MapStoreConfig mapStoreConfig = mapStoreContext.getMapStoreConfig();
        WriteBehindStore mapDataStore = new WriteBehindStore(mapStoreContext, partitionId);
        mapDataStore.setWriteBehindQueue(MapDataStores.newWriteBehindQueue(mapServiceContext, mapStoreConfig.isWriteCoalescing()));
        mapDataStore.setWriteBehindProcessor(writeBehindProcessor);
        return mapDataStore;
    }

    private static WriteBehindQueue newWriteBehindQueue(MapServiceContext mapServiceContext, boolean writeCoalescing) {
        HazelcastProperties hazelcastProperties = mapServiceContext.getNodeEngine().getProperties();
        int capacity = hazelcastProperties.getInteger(GroupProperty.MAP_WRITE_BEHIND_QUEUE_CAPACITY);
        AtomicInteger counter = mapServiceContext.getWriteBehindQueueItemCounter();
        return writeCoalescing ? WriteBehindQueues.createDefaultWriteBehindQueue() : WriteBehindQueues.createBoundedWriteBehindQueue(capacity, counter);
    }

    public static <K, V> MapDataStore<K, V> createWriteThroughStore(MapStoreContext mapStoreContext) {
        MapStoreWrapper store = mapStoreContext.getMapStoreWrapper();
        MapServiceContext mapServiceContext = mapStoreContext.getMapServiceContext();
        NodeEngine nodeEngine = mapServiceContext.getNodeEngine();
        SerializationService serializationService = nodeEngine.getSerializationService();
        return new WriteThroughStore(store, serializationService);
    }

    public static <K, V> MapDataStore<K, V> emptyStore() {
        return EMPTY_MAP_DATA_STORE;
    }
}

