/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.map.impl.mapstore.writebehind;

import com.att.aft.dme2.hazelcast.map.impl.MapServiceContext;
import com.att.aft.dme2.hazelcast.map.impl.PartitionContainer;
import com.att.aft.dme2.hazelcast.map.impl.mapstore.MapDataStore;
import com.att.aft.dme2.hazelcast.map.impl.mapstore.MapDataStores;
import com.att.aft.dme2.hazelcast.map.impl.mapstore.MapStoreContext;
import com.att.aft.dme2.hazelcast.map.impl.mapstore.MapStoreManager;
import com.att.aft.dme2.hazelcast.map.impl.mapstore.writebehind.StoreEvent;
import com.att.aft.dme2.hazelcast.map.impl.mapstore.writebehind.StoreListener;
import com.att.aft.dme2.hazelcast.map.impl.mapstore.writebehind.StoreWorker;
import com.att.aft.dme2.hazelcast.map.impl.mapstore.writebehind.WriteBehindProcessor;
import com.att.aft.dme2.hazelcast.map.impl.mapstore.writebehind.WriteBehindProcessors;
import com.att.aft.dme2.hazelcast.map.impl.mapstore.writebehind.WriteBehindStore;
import com.att.aft.dme2.hazelcast.map.impl.mapstore.writebehind.entry.DelayedEntry;
import com.att.aft.dme2.hazelcast.map.impl.recordstore.RecordStore;
import com.att.aft.dme2.hazelcast.spi.ExecutionService;
import com.att.aft.dme2.hazelcast.spi.NodeEngine;
import com.att.aft.dme2.hazelcast.spi.TaskScheduler;
import com.att.aft.dme2.hazelcast.util.executor.ExecutorType;
import java.util.concurrent.TimeUnit;

public class WriteBehindManager
implements MapStoreManager {
    private static final String EXECUTOR_NAME_PREFIX = "hz:scheduled:mapstore:";
    private static final int EXECUTOR_DEFAULT_QUEUE_CAPACITY = 10000;
    private final TaskScheduler taskScheduler;
    private final WriteBehindProcessor writeBehindProcessor;
    private final StoreWorker storeWorker;
    private final String executorName;
    private final MapStoreContext mapStoreContext;

    public WriteBehindManager(MapStoreContext mapStoreContext) {
        this.mapStoreContext = mapStoreContext;
        this.writeBehindProcessor = this.newWriteBehindProcessor(mapStoreContext);
        this.storeWorker = new StoreWorker(mapStoreContext, this.writeBehindProcessor);
        this.executorName = EXECUTOR_NAME_PREFIX + mapStoreContext.getMapName();
        MapServiceContext mapServiceContext = mapStoreContext.getMapServiceContext();
        this.taskScheduler = this.getTaskScheduler(mapServiceContext);
    }

    @Override
    public void start() {
        this.taskScheduler.scheduleWithRepetition(this.storeWorker, 1L, 1L, TimeUnit.SECONDS);
    }

    @Override
    public void stop() {
        MapServiceContext mapServiceContext = this.mapStoreContext.getMapServiceContext();
        NodeEngine nodeEngine = mapServiceContext.getNodeEngine();
        nodeEngine.getExecutionService().shutdownExecutor(this.executorName);
    }

    @Override
    public MapDataStore getMapDataStore(String mapName, int partitionId) {
        return MapDataStores.createWriteBehindStore(this.mapStoreContext, partitionId, this.writeBehindProcessor);
    }

    private WriteBehindProcessor newWriteBehindProcessor(MapStoreContext mapStoreContext) {
        WriteBehindProcessor writeBehindProcessor = WriteBehindProcessors.createWriteBehindProcessor(mapStoreContext);
        InternalStoreListener storeListener = new InternalStoreListener(mapStoreContext);
        writeBehindProcessor.addStoreListener(storeListener);
        return writeBehindProcessor;
    }

    private TaskScheduler getTaskScheduler(MapServiceContext mapServiceContext) {
        NodeEngine nodeEngine = mapServiceContext.getNodeEngine();
        ExecutionService executionService = nodeEngine.getExecutionService();
        executionService.register(this.executorName, 1, 10000, ExecutorType.CACHED);
        return executionService.getTaskScheduler(this.executorName);
    }

    private static class InternalStoreListener
    implements StoreListener<DelayedEntry> {
        private final MapStoreContext mapStoreContext;

        InternalStoreListener(MapStoreContext mapStoreContext) {
            this.mapStoreContext = mapStoreContext;
        }

        @Override
        public void beforeStore(StoreEvent<DelayedEntry> storeEvent) {
        }

        @Override
        public void afterStore(StoreEvent<DelayedEntry> storeEvent) {
            DelayedEntry delayedEntry = storeEvent.getSource();
            int partitionId = delayedEntry.getPartitionId();
            WriteBehindStore writeBehindStore = this.getWriteBehindStoreOrNull(partitionId);
            if (writeBehindStore == null) {
                return;
            }
            writeBehindStore.removeFromStagingArea(delayedEntry);
        }

        private WriteBehindStore getWriteBehindStoreOrNull(int partitionId) {
            MapStoreContext mapStoreContext = this.mapStoreContext;
            MapServiceContext mapServiceContext = mapStoreContext.getMapServiceContext();
            PartitionContainer partitionContainer = mapServiceContext.getPartitionContainer(partitionId);
            RecordStore recordStore = partitionContainer.getExistingRecordStore(mapStoreContext.getMapName());
            if (recordStore == null) {
                return null;
            }
            return (WriteBehindStore)recordStore.getMapDataStore();
        }
    }
}

