/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.map.impl.nearcache;

import com.att.aft.dme2.hazelcast.cache.impl.nearcache.NearCache;
import com.att.aft.dme2.hazelcast.internal.cluster.ClusterService;
import com.att.aft.dme2.hazelcast.map.impl.MapContainer;
import com.att.aft.dme2.hazelcast.map.impl.MapServiceContext;
import com.att.aft.dme2.hazelcast.map.impl.nearcache.Invalidation;
import com.att.aft.dme2.hazelcast.map.impl.nearcache.NearCacheInvalidator;
import com.att.aft.dme2.hazelcast.map.impl.nearcache.NearCacheProvider;
import com.att.aft.dme2.hazelcast.map.impl.nearcache.SingleNearCacheInvalidation;
import com.att.aft.dme2.hazelcast.map.impl.operation.MapOperation;
import com.att.aft.dme2.hazelcast.map.impl.operation.NearCacheBatchInvalidationOperation;
import com.att.aft.dme2.hazelcast.map.impl.operation.NearCacheSingleInvalidationOperation;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.spi.EventService;
import com.att.aft.dme2.hazelcast.spi.NodeEngine;
import com.att.aft.dme2.hazelcast.spi.OperationService;
import com.att.aft.dme2.hazelcast.util.CollectionUtil;
import java.util.List;

public abstract class AbstractNearCacheInvalidator
implements NearCacheInvalidator {
    protected final EventService eventService;
    protected final OperationService operationService;
    protected final ClusterService clusterService;
    protected final MapServiceContext mapServiceContext;
    protected final NearCacheProvider nearCacheProvider;
    protected final NodeEngine nodeEngine;

    public AbstractNearCacheInvalidator(MapServiceContext mapServiceContext, NearCacheProvider nearCacheProvider) {
        this.mapServiceContext = mapServiceContext;
        this.nearCacheProvider = nearCacheProvider;
        this.nodeEngine = mapServiceContext.getNodeEngine();
        this.eventService = this.nodeEngine.getEventService();
        this.operationService = this.nodeEngine.getOperationService();
        this.clusterService = this.nodeEngine.getClusterService();
    }

    public void invalidateLocal(String mapName, Data key, List<Data> keys) {
        if (!this.isMemberNearCacheInvalidationEnabled(mapName)) {
            return;
        }
        NearCache nearCache = this.nearCacheProvider.getOrNullNearCache(mapName);
        if (nearCache != null) {
            if (key != null) {
                nearCache.remove(key);
            } else if (!CollectionUtil.isEmpty(keys)) {
                for (Data data : keys) {
                    nearCache.remove(data);
                }
            }
        }
    }

    @Override
    public void clearLocalNearCache(String mapName) {
        if (!this.isMemberNearCacheInvalidationEnabled(mapName)) {
            return;
        }
        NearCache nearCache = this.nearCacheProvider.getOrNullNearCache(mapName);
        if (nearCache != null) {
            nearCache.clear();
        }
    }

    protected boolean isMemberNearCacheInvalidationEnabled(String mapName) {
        MapContainer mapContainer = this.mapServiceContext.getMapContainer(mapName);
        return mapContainer.isMemberNearCacheInvalidationEnabled();
    }

    protected boolean hasInvalidationListener(String mapName) {
        MapContainer mapContainer = this.mapServiceContext.getMapContainer(mapName);
        return mapContainer.hasInvalidationListener();
    }

    protected Data toHeapData(Data key) {
        return this.mapServiceContext.toData(key);
    }

    public static Object getOrderKey(String mapName, Invalidation invalidation) {
        if (invalidation instanceof SingleNearCacheInvalidation) {
            return ((SingleNearCacheInvalidation)invalidation).getKey();
        }
        return mapName;
    }

    public static MapOperation createSingleOrBatchInvalidationOperation(String mapName, Data key, List<Data> keys) {
        if (key != null) {
            return new NearCacheSingleInvalidationOperation(mapName, key);
        }
        if (keys != null) {
            return new NearCacheBatchInvalidationOperation(mapName, keys);
        }
        throw new IllegalArgumentException("One of key or keys should be provided for invalidation");
    }
}

