/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.map.impl.nearcache;

import com.att.aft.dme2.hazelcast.map.impl.nearcache.KeyStateMarker;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.util.HashUtil;
import java.util.concurrent.atomic.AtomicLongArray;

public class KeyStateMarkerImpl
implements KeyStateMarker {
    private final int markCount;
    private volatile AtomicLongArray marks;

    public KeyStateMarkerImpl(int markCount) {
        this.markCount = markCount;
        this.marks = new AtomicLongArray(markCount);
    }

    @Override
    public boolean tryMark(Object key) {
        return this.casState(key, KeyStateMarker.STATE.UNMARKED, KeyStateMarker.STATE.MARKED);
    }

    @Override
    public boolean tryUnmark(Object key) {
        return this.casState(key, KeyStateMarker.STATE.MARKED, KeyStateMarker.STATE.UNMARKED);
    }

    @Override
    public boolean tryRemove(Object key) {
        return this.casState(key, KeyStateMarker.STATE.MARKED, KeyStateMarker.STATE.REMOVED);
    }

    @Override
    public void forceUnmark(Object key) {
        int slot = this.getSlot(key);
        this.marks.set(slot, KeyStateMarker.STATE.UNMARKED.getState());
    }

    @Override
    public void init() {
        this.marks = new AtomicLongArray(this.markCount);
    }

    private boolean casState(Object key, KeyStateMarker.STATE expect, KeyStateMarker.STATE update) {
        int slot = this.getSlot(key);
        return this.marks.compareAndSet(slot, expect.getState(), update.getState());
    }

    private int getSlot(Object key) {
        int hash = key instanceof Data ? ((Data)key).getPartitionHash() : key.hashCode();
        return HashUtil.hashToIndex(hash, this.markCount);
    }
}

