/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.map.impl.nearcache;

import com.att.aft.dme2.hazelcast.cache.impl.nearcache.NearCache;
import com.att.aft.dme2.hazelcast.map.impl.MapContainer;
import com.att.aft.dme2.hazelcast.map.impl.MapServiceContext;
import com.att.aft.dme2.hazelcast.map.impl.SizeEstimator;
import com.att.aft.dme2.hazelcast.map.impl.nearcache.BatchInvalidator;
import com.att.aft.dme2.hazelcast.map.impl.nearcache.NearCacheImpl;
import com.att.aft.dme2.hazelcast.map.impl.nearcache.NearCacheInvalidator;
import com.att.aft.dme2.hazelcast.map.impl.nearcache.NonStopInvalidator;
import com.att.aft.dme2.hazelcast.map.impl.nearcache.StaleReadPreventerNearCacheWrapper;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.spi.NodeEngine;
import com.att.aft.dme2.hazelcast.spi.properties.GroupProperty;
import com.att.aft.dme2.hazelcast.spi.properties.HazelcastProperties;
import com.att.aft.dme2.hazelcast.util.ConcurrencyUtil;
import com.att.aft.dme2.hazelcast.util.ConstructorFunction;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class NearCacheProvider {
    protected final ConcurrentMap<String, NearCache> nearCacheMap = new ConcurrentHashMap<String, NearCache>();
    protected final ConstructorFunction<String, NearCache> nearCacheConstructor = new ConstructorFunction<String, NearCache>(){

        @Override
        public NearCache createNew(String mapName) {
            MapContainer mapContainer = NearCacheProvider.this.mapServiceContext.getMapContainer(mapName);
            SizeEstimator nearCacheSizeEstimator = mapContainer.getNearCacheSizeEstimator();
            NearCacheImpl nearCache = new NearCacheImpl(mapName, NearCacheProvider.this.nodeEngine);
            nearCache.setNearCacheSizeEstimator(nearCacheSizeEstimator);
            int partitionCount = NearCacheProvider.this.mapServiceContext.getNodeEngine().getPartitionService().getPartitionCount();
            return StaleReadPreventerNearCacheWrapper.wrapAsStaleReadPreventerNearCache(nearCache, partitionCount);
        }
    };
    protected final MapServiceContext mapServiceContext;
    protected final NodeEngine nodeEngine;
    protected final NearCacheInvalidator nearCacheInvalidator;

    public NearCacheProvider(MapServiceContext mapServiceContext) {
        this.mapServiceContext = mapServiceContext;
        this.nodeEngine = mapServiceContext.getNodeEngine();
        this.nearCacheInvalidator = this.createNearCacheInvalidator(mapServiceContext);
    }

    protected NearCacheInvalidator createNearCacheInvalidator(MapServiceContext mapServiceContext) {
        return this.isBatchingEnabled() ? new BatchInvalidator(mapServiceContext, this) : new NonStopInvalidator(mapServiceContext, this);
    }

    private boolean isBatchingEnabled() {
        HazelcastProperties hazelcastProperties = this.nodeEngine.getProperties();
        int batchSize = hazelcastProperties.getInteger(GroupProperty.MAP_INVALIDATION_MESSAGE_BATCH_SIZE);
        return hazelcastProperties.getBoolean(GroupProperty.MAP_INVALIDATION_MESSAGE_BATCH_ENABLED) && batchSize > 1;
    }

    public NearCache getOrCreateNearCache(String mapName) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.nearCacheMap, mapName, this.nearCacheConstructor);
    }

    NearCache getOrNullNearCache(String mapName) {
        return (NearCache)this.nearCacheMap.get(mapName);
    }

    public void reset() {
        Collection nearCaches = this.nearCacheMap.values();
        for (NearCache nearCache : nearCaches) {
            nearCache.clear();
        }
        this.nearCacheMap.clear();
        this.nearCacheInvalidator.reset();
    }

    public void shutdown() {
        Collection nearCaches = this.nearCacheMap.values();
        for (NearCache nearCache : nearCaches) {
            nearCache.destroy();
        }
        this.nearCacheMap.clear();
        this.nearCacheInvalidator.shutdown();
    }

    public void destroyNearCache(String mapName) {
        NearCache nearCache = (NearCache)this.nearCacheMap.remove(mapName);
        if (nearCache != null) {
            nearCache.destroy();
        }
        this.nearCacheInvalidator.destroy(mapName);
    }

    public Object getFromNearCache(String mapName, Data key) {
        MapContainer mapContainer = this.mapServiceContext.getMapContainer(mapName);
        if (!mapContainer.hasMemberNearCache()) {
            return null;
        }
        NearCache nearCache = this.getOrCreateNearCache(mapName);
        return nearCache.get(key);
    }

    public NearCacheInvalidator getNearCacheInvalidator() {
        return this.nearCacheInvalidator;
    }
}

