/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.map.impl.nearcache;

import com.att.aft.dme2.hazelcast.core.EntryEventType;
import com.att.aft.dme2.hazelcast.core.Member;
import com.att.aft.dme2.hazelcast.map.impl.EventListenerFilter;
import com.att.aft.dme2.hazelcast.map.impl.MapServiceContext;
import com.att.aft.dme2.hazelcast.map.impl.nearcache.AbstractNearCacheInvalidator;
import com.att.aft.dme2.hazelcast.map.impl.nearcache.BatchNearCacheInvalidation;
import com.att.aft.dme2.hazelcast.map.impl.nearcache.CleaningNearCacheInvalidation;
import com.att.aft.dme2.hazelcast.map.impl.nearcache.Invalidation;
import com.att.aft.dme2.hazelcast.map.impl.nearcache.NearCacheProvider;
import com.att.aft.dme2.hazelcast.map.impl.nearcache.SingleNearCacheInvalidation;
import com.att.aft.dme2.hazelcast.map.impl.operation.MapOperation;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.spi.EventFilter;
import com.att.aft.dme2.hazelcast.spi.EventRegistration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class NonStopInvalidator
extends AbstractNearCacheInvalidator {
    public NonStopInvalidator(MapServiceContext mapServiceContext, NearCacheProvider nearCacheProvider) {
        super(mapServiceContext, nearCacheProvider);
    }

    @Override
    public void invalidate(String mapName, Data key, String sourceUuid) {
        this.invalidateInternal(mapName, key, null, sourceUuid);
    }

    @Override
    public void invalidate(String mapName, List<Data> keys, String sourceUuid) {
        this.invalidateInternal(mapName, null, keys, sourceUuid);
    }

    @Override
    public void sendClientNearCacheClearEvent(String mapName, String sourceUuid) {
        this.invalidateClient(mapName, null, null, sourceUuid);
    }

    @Override
    public void destroy(String mapName) {
    }

    @Override
    public void reset() {
    }

    @Override
    public void shutdown() {
    }

    private void invalidateInternal(String mapName, Data key, List<Data> keys, String sourceUuid) {
        this.invalidateMember(mapName, key, keys, sourceUuid);
        this.invalidateClient(mapName, key, keys, sourceUuid);
        this.invalidateLocal(mapName, key, keys);
    }

    protected void invalidateClient(String mapName, Data key, List<Data> keys, String sourceUuid) {
        if (!this.hasInvalidationListener(mapName)) {
            return;
        }
        Invalidation invalidation = null;
        Collection<EventRegistration> registrations = this.eventService.getRegistrations("hz:impl:mapService", mapName);
        for (EventRegistration registration : registrations) {
            EventFilter filter = registration.getFilter();
            if (!(filter instanceof EventListenerFilter) || !filter.eval(EntryEventType.INVALIDATION.getType())) continue;
            if (invalidation == null) {
                invalidation = NonStopInvalidator.newInvalidation(mapName, key, keys, sourceUuid);
            }
            Object orderKey = NonStopInvalidator.getOrderKey(mapName, invalidation);
            this.eventService.publishEvent("hz:impl:mapService", registration, (Object)invalidation, orderKey.hashCode());
        }
    }

    private static Invalidation newInvalidation(String mapName, Data key, List<Data> keys, String sourceUuid) {
        if (key != null) {
            return new SingleNearCacheInvalidation(mapName, key, sourceUuid);
        }
        if (keys != null) {
            BatchNearCacheInvalidation batch = new BatchNearCacheInvalidation(mapName, keys.size());
            for (Data data : keys) {
                batch.add(new SingleNearCacheInvalidation(mapName, data, sourceUuid));
            }
            return batch;
        }
        return new CleaningNearCacheInvalidation(mapName, sourceUuid);
    }

    protected void invalidateMember(String mapName, Data key, List<Data> keys, String sourceUuid) {
        if (!this.isMemberNearCacheInvalidationEnabled(mapName)) {
            return;
        }
        MapOperation operation = null;
        Set<Member> members = this.clusterService.getMembers();
        for (Member member : members) {
            if (member.localMember() || member.getUuid().equals(sourceUuid)) continue;
            if (operation == null) {
                operation = NonStopInvalidator.createSingleOrBatchInvalidationOperation(mapName, key, keys);
            }
            this.operationService.send(operation, member.getAddress());
        }
    }
}

