/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.map.impl.operation;

import com.att.aft.dme2.hazelcast.core.EntryEventType;
import com.att.aft.dme2.hazelcast.core.EntryView;
import com.att.aft.dme2.hazelcast.map.EntryBackupProcessor;
import com.att.aft.dme2.hazelcast.map.impl.EntryViews;
import com.att.aft.dme2.hazelcast.map.impl.operation.AbstractMultipleEntryOperation;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import java.io.IOException;

abstract class AbstractMultipleEntryBackupOperation
extends AbstractMultipleEntryOperation {
    protected AbstractMultipleEntryBackupOperation() {
    }

    protected AbstractMultipleEntryBackupOperation(String name, EntryBackupProcessor backupProcessor) {
        super(name, backupProcessor);
    }

    @Override
    public void afterRun() throws Exception {
        this.publishWanReplicationEventBackups();
    }

    protected void publishWanReplicationEventBackups() {
        for (AbstractMultipleEntryOperation.WanEventWrapper wanEventWrapper : this.wanEventList) {
            this.publishWanReplicationEventBackup(wanEventWrapper.getKey(), wanEventWrapper.getValue(), wanEventWrapper.getEventType());
        }
    }

    protected void publishWanReplicationEventBackup(Data key, Object value, EntryEventType eventType) {
        if (this.mapContainer.isWanReplicationEnabled()) {
            if (EntryEventType.REMOVED.equals((Object)eventType)) {
                this.mapEventPublisher.publishWanReplicationRemoveBackup(this.name, key, this.getNow());
            } else {
                Object record = this.recordStore.getRecord(key);
                if (record != null) {
                    Data dataValueAsData = this.toData(value);
                    EntryView<Data, Data> entryView = EntryViews.createSimpleEntryView(key, dataValueAsData, record);
                    this.mapEventPublisher.publishWanReplicationUpdateBackup(this.name, entryView);
                }
            }
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.wanEventList.size());
        for (AbstractMultipleEntryOperation.WanEventWrapper wanEventWrapper : this.wanEventList) {
            out.writeData(wanEventWrapper.getKey());
            out.writeData(wanEventWrapper.getValue());
            out.writeInt(wanEventWrapper.getEventType().getType());
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            Data key = in.readData();
            Data value = in.readData();
            EntryEventType entryEventType = EntryEventType.getByType(in.readInt());
            this.wanEventList.add(new AbstractMultipleEntryOperation.WanEventWrapper(key, value, entryEventType));
        }
    }
}

