/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.map.impl.operation;

import com.att.aft.dme2.hazelcast.map.impl.operation.MapOperation;
import com.att.aft.dme2.hazelcast.map.impl.record.Record;
import com.att.aft.dme2.hazelcast.map.impl.record.Records;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.query.impl.Index;
import com.att.aft.dme2.hazelcast.query.impl.Indexes;
import com.att.aft.dme2.hazelcast.query.impl.QueryableEntry;
import com.att.aft.dme2.hazelcast.spi.PartitionAwareOperation;
import com.att.aft.dme2.hazelcast.spi.impl.MutatingOperation;
import com.att.aft.dme2.hazelcast.spi.serialization.SerializationService;
import com.att.aft.dme2.hazelcast.util.Clock;
import java.io.IOException;
import java.util.Iterator;

public class AddIndexOperation
extends MapOperation
implements PartitionAwareOperation,
MutatingOperation {
    private String attributeName;
    private boolean ordered;

    public AddIndexOperation() {
    }

    public AddIndexOperation(String name, String attributeName, boolean ordered) {
        super(name);
        this.attributeName = attributeName;
        this.ordered = ordered;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public void run() throws Exception {
        Indexes indexes = this.mapContainer.getIndexes();
        Index index = indexes.addOrGetIndex(this.attributeName, this.ordered);
        long now = this.getNow();
        Iterator<Record> iterator = this.recordStore.iterator(now, false);
        SerializationService serializationService = this.getNodeEngine().getSerializationService();
        while (iterator.hasNext()) {
            Record record = iterator.next();
            Data key = record.getKey();
            Object value = Records.getValueOrCachedValue(record, serializationService);
            QueryableEntry queryEntry = this.mapContainer.newQueryEntry(key, value);
            index.saveEntryIndex(queryEntry, null);
        }
    }

    private long getNow() {
        return Clock.currentTimeMillis();
    }

    @Override
    public Object getResponse() {
        return Boolean.TRUE;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.attributeName);
        out.writeBoolean(this.ordered);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.attributeName = in.readUTF();
        this.ordered = in.readBoolean();
    }
}

