/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.map.impl.operation;

import com.att.aft.dme2.hazelcast.map.MapInterceptor;
import com.att.aft.dme2.hazelcast.map.impl.MapContainer;
import com.att.aft.dme2.hazelcast.map.impl.MapService;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.spi.AbstractOperation;
import com.att.aft.dme2.hazelcast.spi.NamedOperation;
import com.att.aft.dme2.hazelcast.spi.impl.MutatingOperation;
import java.io.IOException;

public class AddInterceptorOperation
extends AbstractOperation
implements MutatingOperation,
NamedOperation {
    private MapService mapService;
    private String id;
    private MapInterceptor mapInterceptor;
    private String mapName;

    public AddInterceptorOperation() {
    }

    public AddInterceptorOperation(String id, MapInterceptor mapInterceptor, String mapName) {
        this.id = id;
        this.mapInterceptor = mapInterceptor;
        this.mapName = mapName;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public void run() {
        this.mapService = (MapService)this.getService();
        MapContainer mapContainer = this.mapService.getMapServiceContext().getMapContainer(this.mapName);
        mapContainer.getInterceptorRegistry().register(this.id, this.mapInterceptor);
    }

    @Override
    public Object getResponse() {
        return true;
    }

    @Override
    public void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.mapName = in.readUTF();
        this.id = in.readUTF();
        this.mapInterceptor = (MapInterceptor)in.readObject();
    }

    @Override
    public void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.mapName);
        out.writeUTF(this.id);
        out.writeObject(this.mapInterceptor);
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(", name=").append(this.mapName);
    }

    @Override
    public String getName() {
        return this.mapName;
    }
}

