/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.map.impl.operation;

import com.att.aft.dme2.hazelcast.map.impl.MapService;
import com.att.aft.dme2.hazelcast.map.impl.MapServiceContext;
import com.att.aft.dme2.hazelcast.map.impl.PartitionContainer;
import com.att.aft.dme2.hazelcast.map.impl.recordstore.RecordStore;
import com.att.aft.dme2.hazelcast.nio.Address;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.spi.AbstractOperation;
import com.att.aft.dme2.hazelcast.spi.NodeEngine;
import com.att.aft.dme2.hazelcast.spi.PartitionAwareOperation;
import com.att.aft.dme2.hazelcast.spi.impl.MutatingOperation;
import com.att.aft.dme2.hazelcast.util.Clock;
import java.io.IOException;
import java.util.concurrent.ConcurrentMap;

public class ClearExpiredOperation
extends AbstractOperation
implements PartitionAwareOperation,
MutatingOperation {
    private int expirationPercentage;

    public ClearExpiredOperation(int expirationPercentage) {
        this.expirationPercentage = expirationPercentage;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public void run() throws Exception {
        MapService mapService = (MapService)this.getService();
        MapServiceContext mapServiceContext = mapService.getMapServiceContext();
        PartitionContainer partitionContainer = mapServiceContext.getPartitionContainer(this.getPartitionId());
        ConcurrentMap<String, RecordStore> recordStores = partitionContainer.getMaps();
        boolean backup = !this.isOwner();
        for (RecordStore recordStore : recordStores.values()) {
            if (recordStore.size() <= 0 || !recordStore.isExpirable()) continue;
            recordStore.evictExpiredEntries(this.expirationPercentage, backup);
            recordStore.disposeDeferredBlocks();
        }
    }

    private boolean isOwner() {
        NodeEngine nodeEngine = this.getNodeEngine();
        Address owner = nodeEngine.getPartitionService().getPartitionOwner(this.getPartitionId());
        return nodeEngine.getThisAddress().equals(owner);
    }

    @Override
    public void afterRun() throws Exception {
        MapService mapService = (MapService)this.getService();
        MapServiceContext mapServiceContext = mapService.getMapServiceContext();
        PartitionContainer partitionContainer = mapServiceContext.getPartitionContainer(this.getPartitionId());
        partitionContainer.setHasRunningCleanup(false);
        partitionContainer.setLastCleanupTime(Clock.currentTimeMillis());
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(", expirationPercentage=").append(this.expirationPercentage);
    }
}

