/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.map.impl.operation;

import com.att.aft.dme2.hazelcast.core.EntryEventType;
import com.att.aft.dme2.hazelcast.map.impl.operation.ClearBackupOperation;
import com.att.aft.dme2.hazelcast.map.impl.operation.MapOperation;
import com.att.aft.dme2.hazelcast.spi.BackupAwareOperation;
import com.att.aft.dme2.hazelcast.spi.Operation;
import com.att.aft.dme2.hazelcast.spi.PartitionAwareOperation;
import com.att.aft.dme2.hazelcast.spi.impl.MutatingOperation;

public class ClearOperation
extends MapOperation
implements BackupAwareOperation,
PartitionAwareOperation,
MutatingOperation {
    private boolean shouldBackup;
    private int numberOfClearedEntries;

    public ClearOperation() {
        this(null);
    }

    public ClearOperation(String name) {
        super(name);
        this.createRecordStoreOnDemand = false;
    }

    @Override
    public void run() {
        this.clearLocalNearCache();
        if (this.recordStore == null) {
            return;
        }
        this.numberOfClearedEntries = this.recordStore.clear();
        this.shouldBackup = true;
    }

    @Override
    public void afterRun() throws Exception {
        super.afterRun();
        this.hintMapEvent();
    }

    private void hintMapEvent() {
        this.mapEventPublisher.hintMapEvent(this.getCallerAddress(), this.name, EntryEventType.CLEAR_ALL, this.numberOfClearedEntries, this.getPartitionId());
    }

    @Override
    public boolean shouldBackup() {
        return this.shouldBackup;
    }

    @Override
    public int getSyncBackupCount() {
        return this.mapServiceContext.getMapContainer(this.name).getBackupCount();
    }

    @Override
    public int getAsyncBackupCount() {
        return this.mapServiceContext.getMapContainer(this.name).getAsyncBackupCount();
    }

    @Override
    public Object getResponse() {
        return this.numberOfClearedEntries;
    }

    @Override
    public Operation getBackupOperation() {
        ClearBackupOperation clearBackupOperation = new ClearBackupOperation(this.name);
        clearBackupOperation.setServiceName("hz:impl:mapService");
        return clearBackupOperation;
    }
}

