/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.map.impl.operation;

import com.att.aft.dme2.hazelcast.concurrent.lock.LockWaitNotifyKey;
import com.att.aft.dme2.hazelcast.core.OperationTimeoutException;
import com.att.aft.dme2.hazelcast.map.impl.MapDataSerializerHook;
import com.att.aft.dme2.hazelcast.map.impl.operation.ReadonlyKeyBasedMapOperation;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.att.aft.dme2.hazelcast.spi.BlockingOperation;
import com.att.aft.dme2.hazelcast.spi.DefaultObjectNamespace;
import com.att.aft.dme2.hazelcast.spi.WaitNotifyKey;

public class ContainsKeyOperation
extends ReadonlyKeyBasedMapOperation
implements BlockingOperation,
IdentifiedDataSerializable {
    private transient boolean containsKey;

    public ContainsKeyOperation() {
    }

    public ContainsKeyOperation(String name, Data dataKey) {
        this.name = name;
        this.dataKey = dataKey;
    }

    @Override
    public void run() {
        this.containsKey = this.recordStore.containsKey(this.dataKey);
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 12;
    }

    @Override
    public Object getResponse() {
        return this.containsKey;
    }

    @Override
    public WaitNotifyKey getWaitKey() {
        DefaultObjectNamespace namespace = new DefaultObjectNamespace("hz:impl:mapService", this.name);
        return new LockWaitNotifyKey(namespace, this.dataKey);
    }

    @Override
    public boolean shouldWait() {
        if (this.recordStore.isTransactionallyLocked(this.dataKey)) {
            return !this.recordStore.canAcquireLock(this.dataKey, this.getCallerUuid(), this.getThreadId());
        }
        return false;
    }

    @Override
    public void onWaitExpire() {
        this.sendResponse(new OperationTimeoutException("Cannot read transactionally locked entry!"));
    }
}

