/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.map.impl.operation;

import com.att.aft.dme2.hazelcast.config.InMemoryFormat;
import com.att.aft.dme2.hazelcast.config.MapConfig;
import com.att.aft.dme2.hazelcast.core.EntryEventType;
import com.att.aft.dme2.hazelcast.core.EntryView;
import com.att.aft.dme2.hazelcast.core.ManagedContext;
import com.att.aft.dme2.hazelcast.internal.serialization.InternalSerializationService;
import com.att.aft.dme2.hazelcast.map.EntryBackupProcessor;
import com.att.aft.dme2.hazelcast.map.EntryProcessor;
import com.att.aft.dme2.hazelcast.map.impl.EntryViews;
import com.att.aft.dme2.hazelcast.map.impl.LazyMapEntry;
import com.att.aft.dme2.hazelcast.map.impl.LocalMapStatsProvider;
import com.att.aft.dme2.hazelcast.map.impl.MapContainer;
import com.att.aft.dme2.hazelcast.map.impl.MapServiceContext;
import com.att.aft.dme2.hazelcast.map.impl.operation.EntryBackupOperation;
import com.att.aft.dme2.hazelcast.map.impl.operation.LockAwareOperation;
import com.att.aft.dme2.hazelcast.monitor.impl.LocalMapStatsImpl;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.spi.BackupAwareOperation;
import com.att.aft.dme2.hazelcast.spi.EventService;
import com.att.aft.dme2.hazelcast.spi.Operation;
import com.att.aft.dme2.hazelcast.spi.impl.MutatingOperation;
import com.att.aft.dme2.hazelcast.spi.serialization.SerializationService;
import com.att.aft.dme2.hazelcast.util.Clock;
import java.io.IOException;
import java.util.Map;

public class EntryOperation
extends LockAwareOperation
implements BackupAwareOperation,
MutatingOperation {
    protected Object oldValue;
    private EntryProcessor entryProcessor;
    private EntryEventType eventType;
    private Object response;
    private transient Object dataValue;

    public EntryOperation() {
    }

    public EntryOperation(String name, Data dataKey, EntryProcessor entryProcessor) {
        super(name, dataKey);
        this.entryProcessor = entryProcessor;
    }

    @Override
    public void innerBeforeRun() throws Exception {
        super.innerBeforeRun();
        SerializationService serializationService = this.getNodeEngine().getSerializationService();
        ManagedContext managedContext = serializationService.getManagedContext();
        managedContext.initialize(this.entryProcessor);
    }

    @Override
    public void run() {
        long now = this.getNow();
        this.oldValue = this.recordStore.get(this.dataKey, false);
        Map.Entry entry = this.createMapEntry(this.dataKey, this.oldValue);
        this.response = this.process(entry);
        if (this.noOp(entry)) {
            return;
        }
        if (this.entryRemoved(entry, now)) {
            return;
        }
        this.entryAddedOrUpdated(entry, now);
    }

    @Override
    public void afterRun() throws Exception {
        super.afterRun();
        if (this.eventType == null) {
            return;
        }
        this.mapServiceContext.interceptAfterPut(this.name, this.dataValue);
        if (this.isPostProcessing(this.recordStore)) {
            Object record = this.recordStore.getRecord(this.dataKey);
            this.dataValue = record.getValue();
        }
        this.invalidateNearCache(this.dataKey);
        this.publishEntryEvent();
        this.publishWanReplicationEvent();
        this.evict(this.dataKey);
    }

    @Override
    public void onWaitExpire() {
        this.sendResponse(null);
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    @Override
    public Operation getBackupOperation() {
        EntryBackupProcessor backupProcessor = this.entryProcessor.getBackupProcessor();
        return backupProcessor != null ? new EntryBackupOperation(this.name, this.dataKey, backupProcessor) : null;
    }

    @Override
    public boolean shouldBackup() {
        return this.mapContainer.getTotalBackupCount() > 0 && this.entryProcessor.getBackupProcessor() != null;
    }

    @Override
    public int getAsyncBackupCount() {
        return this.mapContainer.getAsyncBackupCount();
    }

    @Override
    public int getSyncBackupCount() {
        return this.mapContainer.getBackupCount();
    }

    private long getLatencyFrom(long begin) {
        return Clock.currentTimeMillis() - begin;
    }

    private Data toData(Object obj) {
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        return mapServiceContext.toData(obj);
    }

    private long getNow() {
        return Clock.currentTimeMillis();
    }

    private boolean noOp(Map.Entry entry) {
        LazyMapEntry mapEntrySimple = (LazyMapEntry)entry;
        return !mapEntrySimple.isModified() || this.oldValue == null && entry.getValue() == null;
    }

    private boolean entryRemoved(Map.Entry entry, long now) {
        Object value = entry.getValue();
        if (value == null) {
            this.recordStore.delete(this.dataKey);
            this.getLocalMapStats().incrementRemoves(this.getLatencyFrom(now));
            this.eventType = EntryEventType.REMOVED;
            return true;
        }
        return false;
    }

    private void entryAddedOrUpdated(Map.Entry entry, long now) {
        this.dataValue = entry.getValue();
        this.recordStore.set(this.dataKey, this.dataValue, -1L);
        this.getLocalMapStats().incrementPuts(this.getLatencyFrom(now));
        this.eventType = this.oldValue == null ? EntryEventType.ADDED : EntryEventType.UPDATED;
    }

    private Data process(Map.Entry entry) {
        Object result = this.entryProcessor.process(entry);
        return this.toData(result);
    }

    private Map.Entry createMapEntry(Data key, Object value) {
        InternalSerializationService serializationService = (InternalSerializationService)this.getNodeEngine().getSerializationService();
        return new LazyMapEntry(key, value, serializationService, this.mapContainer.getExtractors());
    }

    private LocalMapStatsImpl getLocalMapStats() {
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        LocalMapStatsProvider localMapStatsProvider = mapServiceContext.getLocalMapStatsProvider();
        return localMapStatsProvider.getLocalMapStatsImpl(this.name);
    }

    private boolean hasRegisteredListenerForThisMap() {
        EventService eventService = this.getNodeEngine().getEventService();
        return eventService.hasEventRegistration("hz:impl:mapService", this.name);
    }

    private void nullifyOldValueIfNecessary() {
        MapConfig mapConfig = this.mapContainer.getMapConfig();
        InMemoryFormat format = mapConfig.getInMemoryFormat();
        if (format == InMemoryFormat.OBJECT && this.eventType != EntryEventType.REMOVED) {
            this.oldValue = null;
        }
    }

    private void publishEntryEvent() {
        if (this.hasRegisteredListenerForThisMap()) {
            this.nullifyOldValueIfNecessary();
            this.mapEventPublisher.publishEvent(this.getCallerAddress(), this.name, this.eventType, this.dataKey, this.oldValue, this.dataValue);
        }
    }

    private void publishWanReplicationEvent() {
        MapContainer mapContainer = this.mapContainer;
        if (mapContainer.getWanReplicationPublisher() == null && mapContainer.getWanMergePolicy() == null) {
            return;
        }
        Data key = this.dataKey;
        if (EntryEventType.REMOVED.equals((Object)this.eventType)) {
            this.mapEventPublisher.publishWanReplicationRemove(this.name, key, this.getNow());
        } else {
            Object record = this.recordStore.getRecord(key);
            if (record != null) {
                this.dataValue = this.toData(this.dataValue);
                EntryView<Data, Object> entryView = EntryViews.createSimpleEntryView(key, this.dataValue, record);
                this.mapEventPublisher.publishWanReplicationUpdate(this.name, entryView);
            }
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.entryProcessor = (EntryProcessor)in.readObject();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.entryProcessor);
    }
}

