/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.map.impl.operation;

import com.att.aft.dme2.hazelcast.map.impl.MapDataSerializerHook;
import com.att.aft.dme2.hazelcast.map.impl.operation.MutatingKeyBasedMapOperation;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.att.aft.dme2.hazelcast.spi.BackupOperation;
import com.att.aft.dme2.hazelcast.util.Clock;
import java.io.IOException;

public class EvictBackupOperation
extends MutatingKeyBasedMapOperation
implements BackupOperation,
IdentifiedDataSerializable {
    protected boolean unlockKey;
    protected boolean disableWanReplicationEvent;

    public EvictBackupOperation() {
    }

    public EvictBackupOperation(String name, Data dataKey) {
        super(name, dataKey);
    }

    public EvictBackupOperation(String name, Data dataKey, boolean unlockKey) {
        super(name, dataKey);
        this.unlockKey = unlockKey;
    }

    public EvictBackupOperation(String name, Data dataKey, boolean unlockKey, boolean disableWanReplicationEvent) {
        super(name, dataKey);
        this.unlockKey = unlockKey;
        this.disableWanReplicationEvent = disableWanReplicationEvent;
    }

    @Override
    public void run() {
        this.recordStore.evict(this.dataKey, true);
        if (this.unlockKey) {
            this.recordStore.forceUnlock(this.dataKey);
        }
    }

    @Override
    public void afterRun() throws Exception {
        if (!this.disableWanReplicationEvent && this.mapContainer.isWanReplicationEnabled()) {
            this.mapEventPublisher.publishWanReplicationRemoveBackup(this.name, this.dataKey, Clock.currentTimeMillis());
        }
    }

    @Override
    public Object getResponse() {
        return Boolean.TRUE;
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 11;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeBoolean(this.unlockKey);
        out.writeBoolean(this.disableWanReplicationEvent);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.unlockKey = in.readBoolean();
        this.disableWanReplicationEvent = in.readBoolean();
    }
}

