/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.map.impl.operation;

import com.att.aft.dme2.hazelcast.concurrent.lock.LockWaitNotifyKey;
import com.att.aft.dme2.hazelcast.core.EntryView;
import com.att.aft.dme2.hazelcast.core.OperationTimeoutException;
import com.att.aft.dme2.hazelcast.map.impl.EntryViews;
import com.att.aft.dme2.hazelcast.map.impl.operation.ReadonlyKeyBasedMapOperation;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.spi.BlockingOperation;
import com.att.aft.dme2.hazelcast.spi.DefaultObjectNamespace;
import com.att.aft.dme2.hazelcast.spi.WaitNotifyKey;

public class GetEntryViewOperation
extends ReadonlyKeyBasedMapOperation
implements BlockingOperation {
    private EntryView<Data, Data> result;

    public GetEntryViewOperation() {
    }

    public GetEntryViewOperation(String name, Data dataKey) {
        super(name, dataKey);
    }

    @Override
    public void run() {
        Object record = this.recordStore.getRecordOrNull(this.dataKey);
        if (record != null) {
            Data value = this.mapServiceContext.toData(record.getValue());
            this.result = EntryViews.createSimpleEntryView(this.dataKey, value, record);
        }
    }

    @Override
    public WaitNotifyKey getWaitKey() {
        return new LockWaitNotifyKey(new DefaultObjectNamespace("hz:impl:mapService", this.name), this.dataKey);
    }

    @Override
    public boolean shouldWait() {
        return this.recordStore.isTransactionallyLocked(this.dataKey) && !this.recordStore.canAcquireLock(this.dataKey, this.getCallerUuid(), this.getThreadId());
    }

    @Override
    public void onWaitExpire() {
        this.sendResponse(new OperationTimeoutException("Cannot read transactionally locked entry!"));
    }

    @Override
    public Object getResponse() {
        return this.result;
    }
}

