/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.map.impl.operation;

import com.att.aft.dme2.hazelcast.concurrent.lock.LockWaitNotifyKey;
import com.att.aft.dme2.hazelcast.core.OperationTimeoutException;
import com.att.aft.dme2.hazelcast.map.impl.MapDataSerializerHook;
import com.att.aft.dme2.hazelcast.map.impl.operation.ReadonlyKeyBasedMapOperation;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.att.aft.dme2.hazelcast.spi.BlockingOperation;
import com.att.aft.dme2.hazelcast.spi.DefaultObjectNamespace;
import com.att.aft.dme2.hazelcast.spi.WaitNotifyKey;

public final class GetOperation
extends ReadonlyKeyBasedMapOperation
implements IdentifiedDataSerializable,
BlockingOperation {
    private Data result;

    public GetOperation() {
    }

    public GetOperation(String name, Data dataKey) {
        super(name, dataKey);
        this.dataKey = dataKey;
    }

    @Override
    public void run() {
        this.result = this.mapServiceContext.toData(this.recordStore.get(this.dataKey, false));
    }

    @Override
    public void afterRun() {
        this.mapServiceContext.interceptAfterGet(this.name, this.result);
    }

    @Override
    public WaitNotifyKey getWaitKey() {
        return new LockWaitNotifyKey(new DefaultObjectNamespace("hz:impl:mapService", this.name), this.dataKey);
    }

    @Override
    public boolean shouldWait() {
        if (this.recordStore.isTransactionallyLocked(this.dataKey)) {
            return !this.recordStore.canAcquireLock(this.dataKey, this.getCallerUuid(), this.getThreadId());
        }
        return false;
    }

    @Override
    public void onWaitExpire() {
        this.sendResponse(new OperationTimeoutException("Cannot read transactionally locked entry!"));
    }

    @Override
    public Data getResponse() {
        return this.result;
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 1;
    }
}

