/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.map.impl.operation;

import com.att.aft.dme2.hazelcast.core.EntryEventType;
import com.att.aft.dme2.hazelcast.core.EntryView;
import com.att.aft.dme2.hazelcast.map.impl.operation.BasePutOperation;
import com.att.aft.dme2.hazelcast.map.impl.operation.PutBackupOperation;
import com.att.aft.dme2.hazelcast.map.impl.operation.RemoveBackupOperation;
import com.att.aft.dme2.hazelcast.map.impl.record.RecordInfo;
import com.att.aft.dme2.hazelcast.map.impl.record.Records;
import com.att.aft.dme2.hazelcast.map.merge.MapMergePolicy;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.spi.Operation;
import java.io.IOException;

public class MergeOperation
extends BasePutOperation {
    private static final int WAN_TTL = -999;
    private static final int DEFAULT_TTL = -1;
    private MapMergePolicy mergePolicy;
    private EntryView<Data, Data> mergingEntry;
    private boolean merged;
    private Data mergingValue;
    private boolean disableWanReplicationEvent;

    public MergeOperation(String name, Data dataKey, EntryView<Data, Data> entryView, MapMergePolicy policy) {
        this(name, dataKey, entryView, policy, false);
    }

    public MergeOperation(String name, Data dataKey, EntryView<Data, Data> entryView, MapMergePolicy policy, boolean disableWanReplicationEvent) {
        super(name, dataKey, null);
        this.mergingEntry = entryView;
        this.mergePolicy = policy;
        this.disableWanReplicationEvent = disableWanReplicationEvent;
    }

    public MergeOperation() {
    }

    @Override
    public void run() {
        Object record;
        Object oldRecord = this.recordStore.getRecord(this.dataKey);
        if (oldRecord != null) {
            this.dataOldValue = this.mapServiceContext.toData(oldRecord.getValue());
        }
        this.merged = this.recordStore.merge(this.dataKey, this.mergingEntry, this.mergePolicy);
        if (this.merged && (record = this.recordStore.getRecord(this.dataKey)) != null) {
            this.dataValue = this.mapServiceContext.toData(record.getValue());
            this.mergingValue = this.mapServiceContext.toData(this.mergingEntry.getValue());
        }
    }

    @Override
    public Object getResponse() {
        return this.merged;
    }

    @Override
    public boolean shouldBackup() {
        return this.merged;
    }

    @Override
    public void afterRun() {
        if (this.merged) {
            this.mapServiceContext.interceptAfterPut(this.name, this.dataValue);
            this.mapEventPublisher.publishEvent(this.getCallerAddress(), this.name, EntryEventType.MERGED, this.dataKey, this.dataOldValue, this.dataValue, this.mergingValue);
            this.invalidateNearCache(this.dataKey);
            this.evict(this.dataKey);
        }
    }

    @Override
    public Operation getBackupOperation() {
        if (this.dataValue == null) {
            return new RemoveBackupOperation(this.name, this.dataKey, false, this.disableWanReplicationEvent);
        }
        Object record = this.recordStore.getRecord(this.dataKey);
        RecordInfo replicationInfo = Records.buildRecordInfo(record);
        return new PutBackupOperation(this.name, this.dataKey, this.dataValue, replicationInfo, false, false, this.disableWanReplicationEvent);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        if (this.disableWanReplicationEvent) {
            this.ttl = -999L;
        }
        super.writeInternal(out);
        out.writeObject(this.mergingEntry);
        out.writeObject(this.mergePolicy);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.mergingEntry = (EntryView)in.readObject();
        this.mergePolicy = (MapMergePolicy)in.readObject();
        if (this.ttl == -999L) {
            this.disableWanReplicationEvent = true;
            this.ttl = -1L;
        }
    }
}

