/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.map.impl.operation;

import com.att.aft.dme2.hazelcast.map.EntryBackupProcessor;
import com.att.aft.dme2.hazelcast.map.impl.operation.MultipleEntryBackupOperation;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.query.Predicate;
import com.att.aft.dme2.hazelcast.util.Preconditions;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

public class MultipleEntryWithPredicateBackupOperation
extends MultipleEntryBackupOperation {
    private Predicate predicate;

    public MultipleEntryWithPredicateBackupOperation() {
    }

    public MultipleEntryWithPredicateBackupOperation(String name, Set<Data> keys, EntryBackupProcessor backupProcessor, Predicate predicate) {
        super(name, keys, backupProcessor);
        this.predicate = Preconditions.checkNotNull(predicate, "predicate cannot be null");
    }

    @Override
    protected boolean isEntryProcessable(Map.Entry entry) {
        return super.isEntryProcessable(entry) && this.predicate.apply(entry);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.predicate);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.predicate = (Predicate)in.readObject();
    }
}

