/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.map.impl.operation;

import com.att.aft.dme2.hazelcast.logging.ILogger;
import com.att.aft.dme2.hazelcast.map.impl.nearcache.AbstractNearCacheInvalidator;
import com.att.aft.dme2.hazelcast.map.impl.nearcache.NearCacheInvalidator;
import com.att.aft.dme2.hazelcast.map.impl.nearcache.NearCacheProvider;
import com.att.aft.dme2.hazelcast.map.impl.operation.MapOperation;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.spi.impl.MutatingOperation;
import com.att.aft.dme2.hazelcast.util.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class NearCacheBatchInvalidationOperation
extends MapOperation
implements MutatingOperation {
    private List<Data> keys;

    public NearCacheBatchInvalidationOperation() {
    }

    public NearCacheBatchInvalidationOperation(String mapName, List<Data> keys) {
        super(mapName);
        this.keys = Preconditions.checkNotNull(keys);
    }

    @Override
    public void run() {
        if (this.mapContainer.hasMemberNearCache()) {
            NearCacheProvider nearCacheProvider = this.mapServiceContext.getNearCacheProvider();
            NearCacheInvalidator nearCacheInvalidator = nearCacheProvider.getNearCacheInvalidator();
            ((AbstractNearCacheInvalidator)nearCacheInvalidator).invalidateLocal(this.name, null, this.keys);
        } else {
            ILogger logger = this.getLogger();
            if (logger.isFinestEnabled()) {
                logger.finest("Near-cache invalidation operation has been accepted while near cache is not enabled for " + this.name + " map. Possible configuration conflict among nodes.");
            }
        }
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.keys.size());
        for (Data key : this.keys) {
            out.writeData(key);
        }
    }

    @Override
    public void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int size = in.readInt();
        ArrayList<Data> keys = new ArrayList<Data>(size);
        for (int i = 0; i < size; ++i) {
            Data key = in.readData();
            keys.add(key);
        }
        this.keys = keys;
    }
}

