/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.map.impl.operation;

import com.att.aft.dme2.hazelcast.logging.ILogger;
import com.att.aft.dme2.hazelcast.map.impl.nearcache.AbstractNearCacheInvalidator;
import com.att.aft.dme2.hazelcast.map.impl.nearcache.NearCacheInvalidator;
import com.att.aft.dme2.hazelcast.map.impl.nearcache.NearCacheProvider;
import com.att.aft.dme2.hazelcast.map.impl.operation.MapOperation;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.spi.impl.MutatingOperation;
import java.io.IOException;

public class NearCacheSingleInvalidationOperation
extends MapOperation
implements MutatingOperation {
    private Data key;

    public NearCacheSingleInvalidationOperation(String mapName, Data key) {
        super(mapName);
        this.key = key;
    }

    public NearCacheSingleInvalidationOperation() {
    }

    @Override
    public void run() {
        if (this.mapContainer.hasMemberNearCache()) {
            NearCacheProvider nearCacheProvider = this.mapServiceContext.getNearCacheProvider();
            NearCacheInvalidator nearCacheInvalidator = nearCacheProvider.getNearCacheInvalidator();
            ((AbstractNearCacheInvalidator)nearCacheInvalidator).invalidateLocal(this.name, this.key, null);
        } else {
            ILogger logger = this.getLogger();
            if (logger.isFinestEnabled()) {
                logger.finest("Near-cache invalidation operation has been accepted while near cache is not enabled for " + this.name + " map. Possible configuration conflict among nodes.");
            }
        }
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.key = in.readData();
    }

    @Override
    public void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeData(this.key);
    }
}

