/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.map.impl.operation;

import com.att.aft.dme2.hazelcast.map.EntryBackupProcessor;
import com.att.aft.dme2.hazelcast.map.impl.operation.AbstractMultipleEntryBackupOperation;
import com.att.aft.dme2.hazelcast.map.impl.record.Record;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.query.Predicate;
import com.att.aft.dme2.hazelcast.query.impl.QueryableEntry;
import com.att.aft.dme2.hazelcast.spi.BackupOperation;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

public class PartitionWideEntryBackupOperation
extends AbstractMultipleEntryBackupOperation
implements BackupOperation {
    public PartitionWideEntryBackupOperation() {
    }

    public PartitionWideEntryBackupOperation(String name, EntryBackupProcessor backupProcessor) {
        super(name, backupProcessor);
    }

    @Override
    public void run() {
        long now = this.getNow();
        Iterator<Record> iterator = this.recordStore.iterator(now, true);
        while (iterator.hasNext()) {
            Object oldValue;
            Record record = iterator.next();
            Data dataKey = record.getKey();
            if (!this.applyPredicate(dataKey, oldValue = record.getValue())) continue;
            Map.Entry entry = this.createMapEntry(dataKey, oldValue);
            this.processBackup(entry);
            if (this.noOp(entry, oldValue) || this.entryRemovedBackup(entry, dataKey)) continue;
            this.entryAddedOrUpdatedBackup(entry, dataKey);
            this.evict(dataKey);
        }
        this.publishWanReplicationEventBackups();
    }

    protected Predicate getPredicate() {
        return null;
    }

    @Override
    public Object getResponse() {
        return true;
    }

    private boolean applyPredicate(Data key, Object value) {
        if (this.getPredicate() == null) {
            return true;
        }
        QueryableEntry queryEntry = this.mapContainer.newQueryEntry(key, value);
        return this.getPredicate().apply(queryEntry);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.backupProcessor = (EntryBackupProcessor)in.readObject();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.backupProcessor);
    }
}

