/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.map.impl.operation;

import com.att.aft.dme2.hazelcast.core.ManagedContext;
import com.att.aft.dme2.hazelcast.map.EntryBackupProcessor;
import com.att.aft.dme2.hazelcast.map.EntryProcessor;
import com.att.aft.dme2.hazelcast.map.impl.MapEntries;
import com.att.aft.dme2.hazelcast.map.impl.operation.AbstractMultipleEntryOperation;
import com.att.aft.dme2.hazelcast.map.impl.operation.PartitionWideEntryBackupOperation;
import com.att.aft.dme2.hazelcast.map.impl.record.Record;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.query.Predicate;
import com.att.aft.dme2.hazelcast.query.TruePredicate;
import com.att.aft.dme2.hazelcast.query.impl.FalsePredicate;
import com.att.aft.dme2.hazelcast.query.impl.QueryableEntry;
import com.att.aft.dme2.hazelcast.spi.BackupAwareOperation;
import com.att.aft.dme2.hazelcast.spi.Operation;
import com.att.aft.dme2.hazelcast.spi.serialization.SerializationService;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

public class PartitionWideEntryOperation
extends AbstractMultipleEntryOperation
implements BackupAwareOperation {
    public PartitionWideEntryOperation(String name, EntryProcessor entryProcessor) {
        super(name, entryProcessor);
    }

    public PartitionWideEntryOperation() {
    }

    @Override
    public void innerBeforeRun() throws Exception {
        super.innerBeforeRun();
        SerializationService serializationService = this.getNodeEngine().getSerializationService();
        ManagedContext managedContext = serializationService.getManagedContext();
        managedContext.initialize(this.entryProcessor);
    }

    @Override
    public void run() {
        long now = this.getNow();
        this.responses = new MapEntries(this.recordStore.size());
        Iterator<Record> iterator = this.recordStore.iterator(now, false);
        while (iterator.hasNext()) {
            Object oldValue;
            Record record = iterator.next();
            Data dataKey = record.getKey();
            if (!this.applyPredicate(dataKey, oldValue = record.getValue())) continue;
            Map.Entry entry = this.createMapEntry(dataKey, oldValue);
            Data response = this.process(entry);
            if (response != null) {
                this.responses.add(dataKey, response);
            }
            if (this.noOp(entry, oldValue, now) || this.entryRemoved(entry, dataKey, oldValue, now)) continue;
            this.entryAddedOrUpdated(entry, dataKey, oldValue, now);
            this.evict(dataKey);
        }
    }

    @Override
    public Object getResponse() {
        return this.responses;
    }

    @Override
    public boolean shouldBackup() {
        return this.mapContainer.getTotalBackupCount() > 0 && this.entryProcessor.getBackupProcessor() != null;
    }

    @Override
    public int getSyncBackupCount() {
        return 0;
    }

    @Override
    public int getAsyncBackupCount() {
        return this.mapContainer.getTotalBackupCount();
    }

    @Override
    public Operation getBackupOperation() {
        EntryBackupProcessor backupProcessor = this.entryProcessor.getBackupProcessor();
        PartitionWideEntryBackupOperation backupOperation = null;
        if (backupProcessor != null) {
            backupOperation = new PartitionWideEntryBackupOperation(this.name, backupProcessor);
            backupOperation.setWanEventList(this.wanEventList);
        }
        return backupOperation;
    }

    private boolean applyPredicate(Data key, Object value) {
        Predicate predicate = this.getPredicate();
        if (predicate == null || TruePredicate.INSTANCE == predicate) {
            return true;
        }
        if (FalsePredicate.INSTANCE == predicate) {
            return false;
        }
        QueryableEntry queryEntry = this.mapContainer.newQueryEntry(key, value);
        return this.getPredicate().apply(queryEntry);
    }

    protected Predicate getPredicate() {
        return null;
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.entryProcessor = (EntryProcessor)in.readObject();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.entryProcessor);
    }
}

