/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.map.impl.operation;

import com.att.aft.dme2.hazelcast.internal.partition.InternalPartitionService;
import com.att.aft.dme2.hazelcast.map.EntryProcessor;
import com.att.aft.dme2.hazelcast.map.impl.MapService;
import com.att.aft.dme2.hazelcast.map.impl.MapServiceContext;
import com.att.aft.dme2.hazelcast.map.impl.operation.MultipleEntryWithPredicateOperation;
import com.att.aft.dme2.hazelcast.map.impl.operation.PartitionWideEntryWithPredicateOperation;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.query.Predicate;
import com.att.aft.dme2.hazelcast.query.TruePredicate;
import com.att.aft.dme2.hazelcast.query.impl.Indexes;
import com.att.aft.dme2.hazelcast.query.impl.QueryableEntry;
import com.att.aft.dme2.hazelcast.query.impl.predicates.QueryOptimizer;
import com.att.aft.dme2.hazelcast.spi.NodeEngine;
import com.att.aft.dme2.hazelcast.spi.Operation;
import com.att.aft.dme2.hazelcast.spi.impl.operationservice.impl.operations.PartitionAwareOperationFactory;
import com.att.aft.dme2.hazelcast.util.CollectionUtil;
import com.att.aft.dme2.hazelcast.util.MapUtil;
import com.att.aft.dme2.hazelcast.util.collection.InflatableSet;
import com.att.aft.dme2.hazelcast.util.collection.Int2ObjectHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PartitionWideEntryWithPredicateOperationFactory
extends PartitionAwareOperationFactory {
    private String name;
    private EntryProcessor entryProcessor;
    private Predicate predicate;
    private transient Map<Integer, List<Data>> partitionIdToKeysMap;

    public PartitionWideEntryWithPredicateOperationFactory() {
    }

    public PartitionWideEntryWithPredicateOperationFactory(String name, EntryProcessor entryProcessor, Predicate predicate, Map<Integer, List<Data>> partitionIdToKeysMap) {
        this(name, entryProcessor, predicate);
        this.partitionIdToKeysMap = partitionIdToKeysMap;
        this.partitions = MapUtil.isNullOrEmpty(partitionIdToKeysMap) ? null : CollectionUtil.toIntArray(partitionIdToKeysMap.keySet());
    }

    public PartitionWideEntryWithPredicateOperationFactory(String name, EntryProcessor entryProcessor, Predicate predicate) {
        this.name = name;
        this.entryProcessor = entryProcessor;
        this.predicate = predicate;
    }

    @Override
    public PartitionAwareOperationFactory createFactoryOnRunner(NodeEngine nodeEngine) {
        Set<Data> keys = this.getKeysFromIndex(nodeEngine);
        Map<Integer, List<Data>> partitionIdToKeysMap = this.getPartitionIdToKeysMap(keys, (InternalPartitionService)nodeEngine.getPartitionService());
        return new PartitionWideEntryWithPredicateOperationFactory(this.name, this.entryProcessor, this.predicate, partitionIdToKeysMap);
    }

    @Override
    public Operation createPartitionOperation(int partition) {
        if (MapUtil.isNullOrEmpty(this.partitionIdToKeysMap)) {
            return new PartitionWideEntryWithPredicateOperation(this.name, this.entryProcessor, this.predicate);
        }
        List<Data> keyList = this.partitionIdToKeysMap.get(partition);
        InflatableSet<Data> keys = InflatableSet.newBuilder(keyList).build();
        return new MultipleEntryWithPredicateOperation(this.name, keys, this.entryProcessor, this.predicate);
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeObject(this.entryProcessor);
        out.writeObject(this.predicate);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        this.entryProcessor = (EntryProcessor)in.readObject();
        this.predicate = (Predicate)in.readObject();
    }

    private Set<Data> getKeysFromIndex(NodeEngine nodeEngine) {
        if (this.predicate == TruePredicate.INSTANCE) {
            return Collections.emptySet();
        }
        MapService mapService = (MapService)nodeEngine.getService("hz:impl:mapService");
        MapServiceContext mapServiceContext = mapService.getMapServiceContext();
        Indexes indexes = mapServiceContext.getMapContainer(this.name).getIndexes();
        QueryOptimizer queryOptimizer = mapServiceContext.getQueryOptimizer();
        this.predicate = queryOptimizer.optimize(this.predicate, indexes);
        Set<QueryableEntry> querySet = indexes.query(this.predicate);
        if (querySet == null) {
            return Collections.emptySet();
        }
        ArrayList<Data> keys = null;
        for (QueryableEntry e : querySet) {
            if (keys == null) {
                keys = new ArrayList<Data>(querySet.size());
            }
            keys.add(e.getKeyData());
        }
        return keys == null ? Collections.emptySet() : InflatableSet.newBuilder(keys).build();
    }

    private Map<Integer, List<Data>> getPartitionIdToKeysMap(Set<Data> keys, InternalPartitionService partitionService) {
        if (CollectionUtil.isEmpty(keys)) {
            return Collections.emptyMap();
        }
        Int2ObjectHashMap<List<Data>> partitionToKeys = new Int2ObjectHashMap<List<Data>>();
        for (Data key : keys) {
            int partitionId = partitionService.getPartitionId(key);
            ArrayList<Data> keyList = (ArrayList<Data>)partitionToKeys.get((Object)partitionId);
            if (keyList == null) {
                keyList = new ArrayList<Data>();
                partitionToKeys.put(Integer.valueOf(partitionId), (List<Data>)keyList);
            }
            keyList.add(key);
        }
        return partitionToKeys;
    }
}

