/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.map.impl.operation;

import com.att.aft.dme2.hazelcast.map.MapInterceptor;
import com.att.aft.dme2.hazelcast.map.impl.InterceptorRegistry;
import com.att.aft.dme2.hazelcast.map.impl.MapContainer;
import com.att.aft.dme2.hazelcast.map.impl.MapService;
import com.att.aft.dme2.hazelcast.map.impl.MapServiceContext;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.DataSerializable;
import com.att.aft.dme2.hazelcast.query.impl.Index;
import com.att.aft.dme2.hazelcast.query.impl.Indexes;
import com.att.aft.dme2.hazelcast.spi.AbstractOperation;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class PostJoinMapOperation
extends AbstractOperation {
    private List<MapIndexInfo> indexInfoList = new LinkedList<MapIndexInfo>();
    private List<InterceptorInfo> interceptorInfoList = new LinkedList<InterceptorInfo>();

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    public void addMapIndex(MapContainer mapContainer) {
        Indexes indexes = mapContainer.getIndexes();
        if (indexes.hasIndex()) {
            MapIndexInfo mapIndexInfo = new MapIndexInfo(mapContainer.getName());
            for (Index index : indexes.getIndexes()) {
                mapIndexInfo.addIndexInfo(index.getAttributeName(), index.isOrdered());
            }
            this.indexInfoList.add(mapIndexInfo);
        }
    }

    public void addMapInterceptors(MapContainer mapContainer) {
        InterceptorRegistry interceptorRegistry = mapContainer.getInterceptorRegistry();
        List<MapInterceptor> interceptorList = interceptorRegistry.getInterceptors();
        Map<String, MapInterceptor> interceptorMap = interceptorRegistry.getId2InterceptorMap();
        HashMap<MapInterceptor, String> revMap = new HashMap<MapInterceptor, String>();
        for (Map.Entry<String, MapInterceptor> entry : interceptorMap.entrySet()) {
            revMap.put(entry.getValue(), entry.getKey());
        }
        InterceptorInfo interceptorInfo = new InterceptorInfo(mapContainer.getName());
        for (MapInterceptor interceptor : interceptorList) {
            interceptorInfo.addInterceptor((String)revMap.get(interceptor), interceptor);
        }
        this.interceptorInfoList.add(interceptorInfo);
    }

    @Override
    public void run() throws Exception {
        MapContainer mapContainer;
        MapService mapService = (MapService)this.getService();
        MapServiceContext mapServiceContext = mapService.getMapServiceContext();
        for (MapIndexInfo mapIndex : this.indexInfoList) {
            mapContainer = mapServiceContext.getMapContainer(mapIndex.mapName);
            Indexes indexes = mapContainer.getIndexes();
            for (MapIndexInfo.IndexInfo indexInfo : mapIndex.lsIndexes) {
                indexes.addOrGetIndex(indexInfo.attributeName, indexInfo.ordered);
            }
        }
        for (InterceptorInfo interceptorInfo : this.interceptorInfoList) {
            mapContainer = mapServiceContext.getMapContainer(interceptorInfo.mapName);
            InterceptorRegistry interceptorRegistry = mapContainer.getInterceptorRegistry();
            Map<String, MapInterceptor> interceptorMap = interceptorRegistry.getId2InterceptorMap();
            List entryList = interceptorInfo.interceptors;
            for (Map.Entry entry : entryList) {
                if (interceptorMap.containsKey(entry.getKey())) continue;
                interceptorRegistry.register((String)entry.getKey(), (MapInterceptor)entry.getValue());
            }
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.indexInfoList.size());
        for (MapIndexInfo mapIndex : this.indexInfoList) {
            mapIndex.writeData(out);
        }
        out.writeInt(this.interceptorInfoList.size());
        for (InterceptorInfo interceptorInfo : this.interceptorInfoList) {
            interceptorInfo.writeData(out);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            MapIndexInfo mapIndexInfo = new MapIndexInfo();
            mapIndexInfo.readData(in);
            this.indexInfoList.add(mapIndexInfo);
        }
        int size2 = in.readInt();
        for (int i = 0; i < size2; ++i) {
            InterceptorInfo info = new InterceptorInfo();
            info.readData(in);
            this.interceptorInfoList.add(info);
        }
    }

    static class MapIndexInfo
    implements DataSerializable {
        private String mapName;
        private List<IndexInfo> lsIndexes = new LinkedList<IndexInfo>();

        public MapIndexInfo(String mapName) {
            this.mapName = mapName;
        }

        public MapIndexInfo() {
        }

        public void addIndexInfo(String attributeName, boolean ordered) {
            this.lsIndexes.add(new IndexInfo(attributeName, ordered));
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeUTF(this.mapName);
            out.writeInt(this.lsIndexes.size());
            for (IndexInfo indexInfo : this.lsIndexes) {
                indexInfo.writeData(out);
            }
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            this.mapName = in.readUTF();
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                IndexInfo indexInfo = new IndexInfo();
                indexInfo.readData(in);
                this.lsIndexes.add(indexInfo);
            }
        }

        static class IndexInfo
        implements DataSerializable {
            private String attributeName;
            private boolean ordered;

            IndexInfo() {
            }

            IndexInfo(String attributeName, boolean ordered) {
                this.attributeName = attributeName;
                this.ordered = ordered;
            }

            @Override
            public void writeData(ObjectDataOutput out) throws IOException {
                out.writeUTF(this.attributeName);
                out.writeBoolean(this.ordered);
            }

            @Override
            public void readData(ObjectDataInput in) throws IOException {
                this.attributeName = in.readUTF();
                this.ordered = in.readBoolean();
            }
        }
    }

    static class InterceptorInfo
    implements DataSerializable {
        private String mapName;
        private final List<Map.Entry<String, MapInterceptor>> interceptors = new LinkedList<Map.Entry<String, MapInterceptor>>();

        InterceptorInfo(String mapName) {
            this.mapName = mapName;
        }

        InterceptorInfo() {
        }

        void addInterceptor(String id, MapInterceptor interceptor) {
            this.interceptors.add(new AbstractMap.SimpleImmutableEntry<String, MapInterceptor>(id, interceptor));
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeUTF(this.mapName);
            out.writeInt(this.interceptors.size());
            for (Map.Entry<String, MapInterceptor> entry : this.interceptors) {
                out.writeUTF(entry.getKey());
                out.writeObject(entry.getValue());
            }
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            this.mapName = in.readUTF();
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                String id = in.readUTF();
                MapInterceptor interceptor = (MapInterceptor)in.readObject();
                this.interceptors.add(new AbstractMap.SimpleImmutableEntry<String, MapInterceptor>(id, interceptor));
            }
        }
    }
}

