/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.map.impl.operation;

import com.att.aft.dme2.hazelcast.core.EntryView;
import com.att.aft.dme2.hazelcast.map.impl.EntryViews;
import com.att.aft.dme2.hazelcast.map.impl.operation.MapOperation;
import com.att.aft.dme2.hazelcast.map.impl.record.Record;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.nio.serialization.DataSerializable;
import com.att.aft.dme2.hazelcast.spi.BackupOperation;
import com.att.aft.dme2.hazelcast.spi.impl.MutatingOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PutFromLoadAllBackupOperation
extends MapOperation
implements BackupOperation,
MutatingOperation,
DataSerializable {
    private List<Data> keyValueSequence;

    public PutFromLoadAllBackupOperation() {
        this.keyValueSequence = Collections.emptyList();
    }

    public PutFromLoadAllBackupOperation(String name, List<Data> keyValueSequence) {
        super(name);
        this.keyValueSequence = keyValueSequence;
    }

    @Override
    public void run() throws Exception {
        List<Data> keyValueSequence = this.keyValueSequence;
        if (keyValueSequence == null || keyValueSequence.isEmpty()) {
            return;
        }
        for (int i = 0; i < keyValueSequence.size(); i += 2) {
            Data key = keyValueSequence.get(i);
            Data value = keyValueSequence.get(i + 1);
            Object object = this.mapServiceContext.toObject(value);
            this.recordStore.putFromLoadBackup(key, object);
            this.publishWanReplicationEvent(key, value, (Record)this.recordStore.getRecord(key));
        }
    }

    @Override
    public void afterRun() throws Exception {
        this.evict(null);
        super.afterRun();
    }

    private void publishWanReplicationEvent(Data key, Data value, Record record) {
        if (record == null) {
            return;
        }
        if (this.mapContainer.getWanReplicationPublisher() != null && this.mapContainer.getWanMergePolicy() != null) {
            EntryView<Data, Data> entryView = EntryViews.createSimpleEntryView(key, value, record);
            this.mapEventPublisher.publishWanReplicationUpdateBackup(this.name, entryView);
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        List<Data> keyValueSequence = this.keyValueSequence;
        int size = keyValueSequence.size();
        out.writeInt(size);
        for (Data data : keyValueSequence) {
            out.writeData(data);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int size = in.readInt();
        if (size < 1) {
            this.keyValueSequence = Collections.emptyList();
        } else {
            ArrayList<Data> tmpKeyValueSequence = new ArrayList<Data>(size);
            for (int i = 0; i < size; ++i) {
                Data data = in.readData();
                tmpKeyValueSequence.add(data);
            }
            this.keyValueSequence = tmpKeyValueSequence;
        }
    }
}

