/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.map.impl.query;

import com.att.aft.dme2.hazelcast.core.MemberLeftException;
import com.att.aft.dme2.hazelcast.map.impl.operation.MapOperation;
import com.att.aft.dme2.hazelcast.map.impl.query.MapQueryEngine;
import com.att.aft.dme2.hazelcast.map.impl.query.QueryResult;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.query.Predicate;
import com.att.aft.dme2.hazelcast.spi.ExceptionAction;
import com.att.aft.dme2.hazelcast.spi.ReadonlyOperation;
import com.att.aft.dme2.hazelcast.spi.exception.TargetNotMemberException;
import com.att.aft.dme2.hazelcast.util.IterationType;
import java.io.IOException;

public class QueryOperation
extends MapOperation
implements ReadonlyOperation {
    private Predicate predicate;
    private QueryResult result;
    private IterationType iterationType;

    public QueryOperation() {
    }

    public QueryOperation(String mapName, Predicate predicate, IterationType iterationType) {
        super(mapName);
        this.predicate = predicate;
        this.iterationType = iterationType;
    }

    @Override
    public void run() throws Exception {
        MapQueryEngine queryEngine = this.mapServiceContext.getMapQueryEngine(this.name);
        this.result = queryEngine.queryLocalPartitions(this.name, this.predicate, this.iterationType);
    }

    @Override
    public ExceptionAction onInvocationException(Throwable throwable) {
        if (throwable instanceof MemberLeftException || throwable instanceof TargetNotMemberException) {
            return ExceptionAction.THROW_EXCEPTION;
        }
        return super.onInvocationException(throwable);
    }

    @Override
    public Object getResponse() {
        return this.result;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.predicate);
        out.writeByte(this.iterationType.getId());
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.predicate = (Predicate)in.readObject();
        this.iterationType = IterationType.getById(in.readByte());
    }
}

